/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.clipboard;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.content.equipment.clipboard.ClipboardBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ClipboardBlockEntity
extends SmartBlockEntity {
    private UUID lastEdit;

    public ClipboardBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.CLIPBOARD, pos, state);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateWrittenState();
    }

    public void onEditedBy(Player player) {
        this.lastEdit = player.getUUID();
        this.notifyUpdate();
        this.updateWrittenState();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.level.isClientSide()) {
            AllClientHandle.INSTANCE.advertiseToAddressHelper(this);
        }
    }

    public void updateWrittenState() {
        boolean shouldBeWritten;
        BlockState blockState = this.getBlockState();
        if (!blockState.is((Block)AllBlocks.CLIPBOARD)) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        boolean isWritten = (Boolean)blockState.getValue((Property)ClipboardBlock.WRITTEN);
        if (isWritten == (shouldBeWritten = this.components().has(AllDataComponents.CLIPBOARD_CONTENT))) {
            return;
        }
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)blockState.setValue((Property)ClipboardBlock.WRITTEN, (Comparable)Boolean.valueOf(shouldBeWritten)));
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket) {
            view.store("components", DataComponentMap.CODEC, (Object)this.components());
        }
        if (this.lastEdit != null) {
            view.store("LastEdit", UUIDUtil.CODEC, (Object)this.lastEdit);
        }
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket) {
            view.read("components", DataComponentMap.CODEC).ifPresent(arg_0 -> ((ClipboardBlockEntity)this).setComponents(arg_0));
            UUID lastEdit = view.read("LastEdit", UUIDUtil.CODEC).orElse(null);
            AllClientHandle.INSTANCE.updateClipboardScreen(lastEdit, this.worldPosition, (ClipboardContent)this.components().getOrDefault(AllDataComponents.CLIPBOARD_CONTENT, (Object)ClipboardContent.EMPTY));
        }
    }
}

