/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.clipboard;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.zurrtum.create.content.equipment.clipboard.ClipboardCloneable;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import com.zurrtum.create.infrastructure.component.ClipboardType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;

public class ClipboardValueSettingsHandler {
    public static InteractionResult rightClickToCopy(Level world, Player player, ItemStack itemStack, InteractionHand hand, BlockHitResult hit, BlockPos pos) {
        return ClipboardValueSettingsHandler.interact(world, player, itemStack, hit.getDirection(), pos, false);
    }

    public static boolean leftClickToPaste(Level world, Player player, ItemStack itemStack, Direction side, BlockPos pos) {
        return ClipboardValueSettingsHandler.interact(world, player, itemStack, side, pos, true) == InteractionResult.SUCCESS;
    }

    private static InteractionResult interact(Level world, Player player, ItemStack itemStack, Direction side, BlockPos pos, boolean paste) {
        boolean anyValid;
        boolean anySuccess;
        CompoundTag tag;
        ClipboardContent clipboardContent;
        block26: {
            if (!itemStack.is((Item)AllItems.CLIPBOARD) || player.isSpectator() || player.isShiftKeyDown()) {
                return null;
            }
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (!(blockEntity instanceof SmartBlockEntity)) {
                return null;
            }
            SmartBlockEntity smartBE = (SmartBlockEntity)blockEntity;
            clipboardContent = (ClipboardContent)itemStack.getOrDefault(AllDataComponents.CLIPBOARD_CONTENT, (Object)ClipboardContent.EMPTY);
            if (smartBE instanceof ClipboardBlockEntity) {
                ClipboardBlockEntity cbe = (ClipboardBlockEntity)smartBE;
                if (!world.isClientSide()) {
                    List<List<ClipboardEntry>> listTo = ClipboardEntry.readAll(clipboardContent);
                    List<List<ClipboardEntry>> listFrom = ClipboardEntry.readAll(cbe.components());
                    ArrayList<ClipboardEntry> toAdd = new ArrayList<ClipboardEntry>();
                    for (List<ClipboardEntry> page : listFrom) {
                        block6: for (ClipboardEntry clipboardEntry : page) {
                            String string = clipboardEntry.text.getString();
                            for (List<ClipboardEntry> pageTo : listTo) {
                                for (ClipboardEntry existing : pageTo) {
                                    if (!string.equals(existing.text.getString())) continue;
                                    continue block6;
                                }
                            }
                            toAdd.add(new ClipboardEntry(clipboardEntry.checked, clipboardEntry.text));
                        }
                    }
                    for (ClipboardEntry entry : toAdd) {
                        List<ClipboardEntry> page = null;
                        for (List<ClipboardEntry> list : listTo) {
                            if (list.size() > 11) continue;
                            page = list;
                            break;
                        }
                        if (page == null) {
                            page = new ArrayList<ClipboardEntry>();
                            listTo.add(page);
                        }
                        page.add(entry);
                        clipboardContent = clipboardContent.setType(ClipboardType.WRITTEN);
                        itemStack.set(AllDataComponents.CLIPBOARD_CONTENT, (Object)clipboardContent);
                    }
                    clipboardContent = clipboardContent.setPages(listTo);
                    itemStack.set(AllDataComponents.CLIPBOARD_CONTENT, (Object)clipboardContent);
                }
                player.displayClientMessage((Component)Component.translatable((String)"create.clipboard.copied_from_clipboard", (Object[])new Object[]{world.getBlockState(pos).getBlock().getName().withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.GREEN), true);
                return InteractionResult.SUCCESS;
            }
            tag = null;
            if (paste && (tag = (CompoundTag)clipboardContent.copiedValues().orElse(null)) == null) {
                return null;
            }
            anySuccess = false;
            anyValid = false;
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(smartBE.problemPath(), Create.LOGGER);){
                TagValueOutput writeView;
                RegistryAccess registryManager = world.registryAccess();
                ValueInput readView = paste ? TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)registryManager, (CompoundTag)tag) : null;
                TagValueOutput tagValueOutput = writeView = paste ? null : TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)registryManager);
                if (smartBE instanceof ClipboardCloneable) {
                    ClipboardCloneable clipboardCloneable = (ClipboardCloneable)((Object)smartBE);
                    anyValid = true;
                    if (paste) {
                        anySuccess = ClipboardValueSettingsHandler.paste(clipboardCloneable, player, readView, side, world.isClientSide());
                    } else {
                        anySuccess = ClipboardValueSettingsHandler.write(clipboardCloneable, (HolderLookup.Provider)registryManager, (ValueOutput)writeView, side, world.isClientSide());
                        if (anySuccess) {
                            tag = writeView.buildResult();
                        }
                    }
                }
                if (anySuccess) break block26;
                for (BehaviourType<ServerLinkBehaviour> behaviourType : List.of(ServerScrollValueBehaviour.TYPE, ServerFilteringBehaviour.TYPE, ServerLinkBehaviour.TYPE)) {
                    ServerLinkBehaviour serverLinkBehaviour = smartBE.getBehaviour(behaviourType);
                    if (!(serverLinkBehaviour instanceof ClipboardCloneable)) continue;
                    ClipboardCloneable cc = serverLinkBehaviour;
                    anyValid = true;
                    if (paste) {
                        anySuccess = ClipboardValueSettingsHandler.paste(cc, player, readView, side, world.isClientSide());
                        continue;
                    }
                    anySuccess = ClipboardValueSettingsHandler.write(cc, (HolderLookup.Provider)registryManager, (ValueOutput)writeView, side, world.isClientSide());
                    if (!anySuccess) continue;
                    tag = writeView.buildResult();
                    break;
                }
            }
        }
        if (!anyValid) {
            return null;
        }
        if (world.isClientSide() || !anySuccess) {
            return InteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)Component.translatable((String)(paste ? "create.clipboard.pasted_to" : "create.clipboard.copied_from"), (Object[])new Object[]{world.getBlockState(pos).getBlock().getName().withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.GREEN), true);
        if (!paste) {
            clipboardContent = clipboardContent.setType(ClipboardType.WRITTEN);
            clipboardContent = clipboardContent.setCopiedValues(tag);
            itemStack.set(AllDataComponents.CLIPBOARD_CONTENT, (Object)clipboardContent);
        }
        return InteractionResult.SUCCESS;
    }

    private static boolean paste(ClipboardCloneable cc, Player player, ValueInput readView, Direction side, boolean simulate) {
        return readView.child(cc.getClipboardKey()).map(v -> cc.readFromClipboard((ValueInput)v, player, side, simulate)).orElse(false);
    }

    private static boolean write(ClipboardCloneable cc, HolderLookup.Provider registryManager, ValueOutput writeView, Direction side, boolean simulate) {
        String clipboardKey = cc.getClipboardKey();
        if (simulate) {
            return cc.canWrite(registryManager, side);
        }
        return cc.writeToClipboard(writeView.child(clipboardKey), side);
    }
}

