/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.transfer;

import com.zurrtum.create.AllRecipeSets;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.content.fluids.transfer.EmptyingRecipe;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class GenericItemEmptying {
    public static boolean canItemBeEmptied(Level world, ItemStack stack) {
        if (PotionFluidHandler.isPotionItem(stack)) {
            return true;
        }
        if (world.isClientSide() ? world.recipeAccess().propertySet(AllRecipeSets.EMPTYING).test(stack) : ((ServerLevel)world).recipeAccess().getRecipeFor(AllRecipeTypes.EMPTYING, (RecipeInput)new SingleRecipeInput(stack), world).isPresent()) {
            return true;
        }
        try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack);){
            if (capability == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = capability.stream().anyMatch(fluidStack -> fluidStack.getAmount() > 0);
            return bl;
        }
    }

    public static Pair<FluidStack, ItemStack> emptyItem(Level world, ItemStack stack, boolean simulate) {
        Optional recipe;
        if (PotionFluidHandler.isPotionItem(stack)) {
            return PotionFluidHandler.emptyPotion(stack, simulate);
        }
        if (!world.isClientSide() && (recipe = ((ServerLevel)world).recipeAccess().getRecipeFor(AllRecipeTypes.EMPTYING, (RecipeInput)new SingleRecipeInput(stack), world)).isPresent()) {
            if (!simulate) {
                stack.shrink(1);
            }
            EmptyingRecipe emptyingRecipe = (EmptyingRecipe)((RecipeHolder)recipe.get()).value();
            return Pair.of(emptyingRecipe.fluidResult(), emptyingRecipe.result());
        }
        try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack.copyWithCount(1));){
            if (capability == null) {
                Pair<FluidStack, ItemStack> emptyingRecipe = Pair.of(FluidStack.EMPTY, ItemStack.EMPTY);
                return emptyingRecipe;
            }
            Optional<FluidStack> findFluid = capability.stream().filter(fluid -> fluid.getAmount() >= 81000).findFirst();
            if (findFluid.isEmpty()) {
                Pair<FluidStack, ItemStack> pair = Pair.of(FluidStack.EMPTY, ItemStack.EMPTY);
                return pair;
            }
            FluidStack resultingFluid = findFluid.get();
            capability.extract(resultingFluid);
            if (!simulate) {
                stack.shrink(1);
            }
            Pair<FluidStack, ItemStack> pair = Pair.of(resultingFluid, capability.getContainer());
            return pair;
        }
    }
}

