/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.clock;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.clock.CuckooClockBlock;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class CuckooClockBlockEntity
extends KineticBlockEntity {
    public LerpedFloat animationProgress = LerpedFloat.linear();
    public Animation animationType = Animation.NONE;
    private boolean sendAnimationUpdate;

    public CuckooClockBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.CUCKOO_CLOCK, pos, state);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CUCKOO_CLOCK);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket) {
            view.read("Animation", Animation.CODEC).ifPresent(animation -> {
                this.animationType = animation;
                this.animationProgress.startWithValue(0.0);
            });
        }
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        if (clientPacket && this.sendAnimationUpdate) {
            view.store("Animation", Animation.CODEC, (Object)this.animationType);
        }
        this.sendAnimationUpdate = false;
        super.write(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide() || this.getSpeed() == 0.0f) {
            return;
        }
        if (this.animationType == Animation.NONE) {
            int dayTime = (int)(this.level.getDayTime() % 24000L);
            int hours = (dayTime / 1000 + 6) % 24;
            int minutes = dayTime % 1000 * 60 / 1000;
            if (hours == 12 && minutes < 5) {
                this.startAnimation(Animation.PIG);
            }
            if (hours == 18 && minutes < 36 && minutes > 31) {
                this.startAnimation(Animation.CREEPER);
            }
        } else {
            float value = this.getAndIncrementProgress();
            if (value > 100.0f) {
                this.animationType = Animation.NONE;
            }
            if (this.animationType == Animation.SURPRISE && Mth.equal((float)this.animationProgress.getValue(), (float)50.0f)) {
                Vec3 center = VecHelper.getCenterOf((Vec3i)this.worldPosition);
                this.level.destroyBlock(this.worldPosition, false);
                this.level.explode(null, AllDamageSources.get((Level)this.level).cuckoo_surprise, null, center.x, center.y, center.z, 3.0f, false, Level.ExplosionInteraction.BLOCK);
            }
        }
    }

    public float getAndIncrementProgress() {
        float value = this.animationProgress.getValue();
        this.animationProgress.setValue(value + 1.0f);
        return value;
    }

    public void startAnimation(Animation animation) {
        this.animationType = animation;
        if (animation != null && CuckooClockBlock.containsSurprise(this.getBlockState())) {
            this.animationType = Animation.SURPRISE;
        }
        this.animationProgress.startWithValue(0.0);
        this.sendAnimationUpdate = true;
        if (animation == Animation.CREEPER) {
            this.awardIfNear(AllAdvancements.CUCKOO_CLOCK, 32);
        }
        this.sendData();
    }

    public static enum Animation implements StringRepresentable
    {
        PIG,
        CREEPER,
        SURPRISE,
        NONE;

        public static final Codec<Animation> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Animation::values);
        }
    }
}

