/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.deployer;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.content.kinetics.deployer.ItemApplicationInput;
import com.zurrtum.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BeltDeployerCallbacks {
    public static BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack s, TransportedItemStackHandlerBehaviour i, DeployerBlockEntity blockEntity) {
        ItemStack held;
        if (blockEntity.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (blockEntity.mode == DeployerBlockEntity.Mode.PUNCH) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        BlockState blockState = blockEntity.getBlockState();
        if (!blockState.hasProperty(DirectionalKineticBlock.FACING) || blockState.getValue(DirectionalKineticBlock.FACING) != Direction.DOWN) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (blockEntity.state != DeployerBlockEntity.State.WAITING) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (blockEntity.redstoneLocked) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        DeployerPlayer player = blockEntity.getPlayer();
        ItemStack itemStack = held = player == null ? ItemStack.EMPTY : player.cast().getMainHandItem();
        if (held.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (blockEntity.getRecipe(s.stack) == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        blockEntity.start();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public static BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack s, TransportedItemStackHandlerBehaviour i, DeployerBlockEntity blockEntity) {
        ItemStack held;
        if (blockEntity.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        BlockState blockState = blockEntity.getBlockState();
        if (!blockState.hasProperty(DirectionalKineticBlock.FACING) || blockState.getValue(DirectionalKineticBlock.FACING) != Direction.DOWN) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        DeployerPlayer player = blockEntity.getPlayer();
        ItemStack itemStack = held = player == null ? ItemStack.EMPTY : player.cast().getMainHandItem();
        if (held.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        Recipe<? extends RecipeInput> recipe = blockEntity.getRecipe(s.stack);
        if (recipe == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (blockEntity.state == DeployerBlockEntity.State.RETRACTING && blockEntity.timer == 1000) {
            BeltDeployerCallbacks.activate(s, i, blockEntity, recipe);
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (blockEntity.state == DeployerBlockEntity.State.WAITING) {
            if (blockEntity.redstoneLocked) {
                return BeltProcessingBehaviour.ProcessingResult.PASS;
            }
            blockEntity.start();
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public static void activate(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, DeployerBlockEntity blockEntity, Recipe<?> recipe) {
        Level world = blockEntity.getLevel();
        TransportedItemStack result = null;
        ItemStack resultItem = null;
        boolean keepHeld = false;
        ServerPlayer player = blockEntity.player.cast();
        ItemStack heldItem = player.getMainHandItem();
        if (recipe instanceof SandPaperPolishingRecipe) {
            SandPaperPolishingRecipe polishingRecipe = (SandPaperPolishingRecipe)recipe;
            resultItem = polishingRecipe.assemble(new SingleRecipeInput(transported.stack), (HolderLookup.Provider)world.registryAccess());
        } else if (recipe instanceof ItemApplicationRecipe) {
            ItemApplicationRecipe itemApplicationRecipe = (ItemApplicationRecipe)recipe;
            resultItem = itemApplicationRecipe.assemble(new ItemApplicationInput(transported.stack, heldItem), (HolderLookup.Provider)world.registryAccess());
            keepHeld = itemApplicationRecipe.keepHeldItem();
        }
        if (resultItem != null && !resultItem.isEmpty()) {
            result = transported.copy();
            boolean centered = BeltHelper.isItemUpright(resultItem);
            result.stack = resultItem;
            result.locked = true;
            result.angle = centered ? 180 : world.random.nextInt(360);
            result.locked = false;
        }
        blockEntity.award(AllAdvancements.DEPLOYER);
        transported.clearFanProcessingData();
        TransportedItemStack left = transported.copy();
        blockEntity.player.setSpawnedItemEffects(transported.stack.copy());
        left.stack.shrink(1);
        if (result == null) {
            resultItem = left.stack.copy();
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(left));
        } else {
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(List.of(result), left));
        }
        if (!keepHeld) {
            if (heldItem.getMaxDamage() > 0) {
                heldItem.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            } else {
                ItemStack leftover = heldItem.getItem().getCraftingRemainder();
                heldItem.shrink(1);
                if (!leftover.isEmpty()) {
                    if (heldItem.isEmpty()) {
                        player.setItemInHand(InteractionHand.MAIN_HAND, leftover);
                    } else if (!player.getInventory().add(leftover)) {
                        player.drop(leftover, false);
                    }
                }
            }
        }
        if (!resultItem.isEmpty()) {
            BeltDeployerCallbacks.awardAdvancements(blockEntity, resultItem);
        }
        BlockPos pos = blockEntity.getBlockPos();
        if (heldItem.isEmpty()) {
            world.playSound(null, pos, (SoundEvent)SoundEvents.ITEM_BREAK.value(), SoundSource.BLOCKS, 0.25f, 1.0f);
        }
        world.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.25f, 0.75f);
        if (recipe instanceof SandPaperPolishingRecipe) {
            AllSoundEvents.SANDING_SHORT.playOnServer(world, (Vec3i)pos, 0.35f, 1.0f);
        }
        blockEntity.notifyUpdate();
    }

    private static void awardAdvancements(DeployerBlockEntity blockEntity, ItemStack created) {
        CreateTrigger advancement;
        if (created.is((Item)AllItems.ANDESITE_CASING)) {
            advancement = AllAdvancements.ANDESITE_CASING;
        } else if (created.is((Item)AllItems.BRASS_CASING)) {
            advancement = AllAdvancements.BRASS_CASING;
        } else if (created.is((Item)AllItems.COPPER_CASING)) {
            advancement = AllAdvancements.COPPER_CASING;
        } else if (created.is((Item)AllItems.RAILWAY_CASING)) {
            advancement = AllAdvancements.TRAIN_CASING;
        } else {
            return;
        }
        blockEntity.award(advancement);
    }
}

