/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.deployer;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperItem;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.deployer.BeltDeployerCallbacks;
import com.zurrtum.create.content.kinetics.deployer.DeployerHandler;
import com.zurrtum.create.content.kinetics.deployer.DeployerItemHandler;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.content.kinetics.deployer.ItemApplicationInput;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SyncedBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DeployerBlockEntity
extends KineticBlockEntity {
    public State state;
    public Mode mode;
    public ItemStack heldItem;
    protected DeployerPlayer player;
    public int timer;
    public float reach;
    public boolean fistBump = false;
    public List<ItemStack> overflowItems = new ArrayList<ItemStack>();
    protected ServerFilteringBehaviour filtering;
    protected boolean redstoneLocked = false;
    protected UUID owner;
    protected String ownerName;
    public Container invHandler;
    private CompoundTag deferredInventoryList;
    public LerpedFloat animatedOffset;
    public BeltProcessingBehaviour processingBehaviour;

    public DeployerBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.DEPLOYER, pos, state);
        this.state = State.WAITING;
        this.mode = Mode.USE;
        this.heldItem = ItemStack.EMPTY;
        this.animatedOffset = LerpedFloat.linear().startWithValue(0.0);
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
        super.preRemoveSideEffects(pos, oldState);
        this.discardPlayer();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new ServerFilteringBehaviour(this);
        behaviours.add(this.filtering);
        this.processingBehaviour = new BeltProcessingBehaviour(this).whenItemEnters((s, i) -> BeltDeployerCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> BeltDeployerCallbacks.whenItemHeld(s, i, this));
        behaviours.add(this.processingBehaviour);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.TRAIN_CASING, AllAdvancements.ANDESITE_CASING, AllAdvancements.BRASS_CASING, AllAdvancements.COPPER_CASING, AllAdvancements.FIST_BUMP, AllAdvancements.DEPLOYER, AllAdvancements.SELF_DEPLOYING);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initHandler();
    }

    public void initHandler() {
        if (this.invHandler != null) {
            return;
        }
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            this.player = DeployerPlayer.create(sLevel, this.owner, this.ownerName);
            ServerPlayer serverPlayer = this.player.cast();
            if (this.deferredInventoryList != null) {
                try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(this.problemPath(), Create.LOGGER);){
                    ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)this.deferredInventoryList);
                    serverPlayer.getInventory().load(view.listOrEmpty("Inventory", ItemStackWithSlot.CODEC));
                }
                this.deferredInventoryList = null;
                this.heldItem = serverPlayer.getMainHandItem();
                this.sendData();
            }
            Vec3 initialPos = VecHelper.getCenterOf((Vec3i)this.worldPosition.relative((Direction)this.getBlockState().getValue(DirectionalKineticBlock.FACING)));
            serverPlayer.setPos(initialPos.x, initialPos.y, initialPos.z);
        }
        this.invHandler = this.createHandler();
    }

    protected void onExtract(ItemStack stack) {
        this.player.cast().setItemInHand(InteractionHand.MAIN_HAND, stack.copy());
        this.sendData();
        this.setChanged();
    }

    public int getTimerSpeed() {
        return (int)(this.getSpeed() == 0.0f ? 0.0f : Mth.clamp((float)Math.abs(this.getSpeed() * 2.0f), (float)8.0f, (float)512.0f));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.level.isClientSide() && this.player != null && this.player.getBlockBreakingProgress() != null && this.level.isEmptyBlock((BlockPos)this.player.getBlockBreakingProgress().getKey())) {
            this.level.destroyBlockProgress(this.player.cast().getId(), (BlockPos)this.player.getBlockBreakingProgress().getKey(), -1);
            this.player.setBlockBreakingProgress(null);
        }
        if (this.timer > 0) {
            this.timer -= this.getTimerSpeed();
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        if (this.player == null) {
            return;
        }
        ServerPlayer serverPlayer = this.player.cast();
        ItemStack stack = serverPlayer.getMainHandItem();
        if (this.state == State.WAITING) {
            if (!this.overflowItems.isEmpty()) {
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            boolean changed = false;
            Inventory inventory = serverPlayer.getInventory();
            int size = inventory.getContainerSize();
            for (int i = 0; i < size && this.overflowItems.size() <= 10; ++i) {
                ItemStack item = inventory.getItem(i);
                if (item.isEmpty() || item == stack && this.filtering.test(item)) continue;
                this.overflowItems.add(item);
                inventory.setItem(i, ItemStack.EMPTY);
                changed = true;
            }
            if (changed) {
                this.sendData();
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            Direction facing = (Direction)this.getBlockState().getValue(DirectionalKineticBlock.FACING);
            if (this.mode == Mode.USE && !DeployerHandler.shouldActivate(stack, this.level, this.worldPosition.relative(facing, 2), facing)) {
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            if (this.mode == Mode.PUNCH && !this.fistBump && this.startFistBump(facing)) {
                return;
            }
            if (this.redstoneLocked) {
                return;
            }
            this.start();
            return;
        }
        if (this.state == State.EXPANDING) {
            if (this.fistBump) {
                this.triggerFistBump();
            }
            this.activate();
            this.state = State.RETRACTING;
            this.timer = 1000;
            this.sendData();
            return;
        }
        if (this.state == State.RETRACTING) {
            this.state = State.WAITING;
            this.timer = 500;
            this.sendData();
            return;
        }
    }

    protected void start() {
        this.state = State.EXPANDING;
        Vec3 movementVector = this.getMovementVector();
        Vec3 rayOrigin = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(movementVector.scale(1.5));
        Vec3 rayTarget = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(movementVector.scale(2.5));
        ClipContext rayTraceContext = new ClipContext(rayOrigin, rayTarget, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.player.cast());
        BlockHitResult result = this.level.clip(rayTraceContext);
        this.reach = (float)(0.5 + Math.min(result.getLocation().subtract(rayOrigin).length(), 0.75));
        this.timer = 1000;
        this.sendData();
    }

    public boolean startFistBump(Direction facing) {
        int i = 0;
        KineticBlockEntity partner = null;
        for (i = 2; i < 5; ++i) {
            BlockPos otherDeployer = this.worldPosition.relative(facing, i);
            if (!this.level.isLoaded(otherDeployer)) {
                return false;
            }
            BlockEntity other = this.level.getBlockEntity(otherDeployer);
            if (!(other instanceof DeployerBlockEntity)) continue;
            DeployerBlockEntity dpe = (DeployerBlockEntity)other;
            partner = dpe;
            break;
        }
        if (partner == null) {
            return false;
        }
        if (((Direction)this.level.getBlockState(partner.getBlockPos()).getValue(DirectionalKineticBlock.FACING)).getOpposite() != facing || ((DeployerBlockEntity)partner).mode != Mode.PUNCH) {
            return false;
        }
        if (partner.getSpeed() == 0.0f) {
            return false;
        }
        for (DeployerBlockEntity be : Arrays.asList(this, partner)) {
            be.fistBump = true;
            be.reach = (float)(i - 2) * 0.5f;
            be.timer = 1000;
            be.state = State.EXPANDING;
            be.sendData();
        }
        return true;
    }

    public void triggerFistBump() {
        int i = 0;
        SyncedBlockEntity deployerBlockEntity = null;
        for (i = 2; i < 5; ++i) {
            BlockPos pos = this.worldPosition.relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING), i);
            if (!this.level.isLoaded(pos)) {
                return;
            }
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (!(blockEntity instanceof DeployerBlockEntity)) continue;
            DeployerBlockEntity dpe = (DeployerBlockEntity)blockEntity;
            deployerBlockEntity = dpe;
            break;
        }
        if (deployerBlockEntity == null) {
            return;
        }
        if (!((DeployerBlockEntity)deployerBlockEntity).fistBump || ((DeployerBlockEntity)deployerBlockEntity).state != State.EXPANDING) {
            return;
        }
        if (((DeployerBlockEntity)deployerBlockEntity).timer > 0) {
            return;
        }
        this.fistBump = false;
        ((DeployerBlockEntity)deployerBlockEntity).fistBump = false;
        ((DeployerBlockEntity)deployerBlockEntity).state = State.RETRACTING;
        ((DeployerBlockEntity)deployerBlockEntity).timer = 1000;
        deployerBlockEntity.sendData();
        this.award(AllAdvancements.FIST_BUMP);
        BlockPos soundLocation = BlockPos.containing((Position)Vec3.atCenterOf((Vec3i)this.worldPosition).add(Vec3.atCenterOf((Vec3i)deployerBlockEntity.getBlockPos())).scale(0.5));
        this.level.playSound(null, soundLocation, SoundEvents.PLAYER_ATTACK_NODAMAGE, SoundSource.BLOCKS, 0.75f, 0.75f);
    }

    protected void activate() {
        Vec3 movementVector = this.getMovementVector();
        Direction direction = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
        Vec3 center = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        BlockPos clickedPos = this.worldPosition.relative(direction, 2);
        ServerPlayer serverPlayer = this.player.cast();
        serverPlayer.setXRot(direction == Direction.UP ? -90.0f : (direction == Direction.DOWN ? 90.0f : 0.0f));
        serverPlayer.setYRot(direction.toYRot());
        if (direction == Direction.DOWN && BlockEntityBehaviour.get((BlockGetter)this.level, clickedPos, TransportedItemStackHandlerBehaviour.TYPE) != null) {
            return;
        }
        DeployerHandler.activate(this.player, center, clickedPos, movementVector, this.mode);
        this.award(AllAdvancements.DEPLOYER);
        if (this.player != null) {
            int count = this.heldItem.getCount();
            this.heldItem = serverPlayer.getMainHandItem();
            if (count != this.heldItem.getCount()) {
                this.setChanged();
            }
        }
    }

    protected Vec3 getMovementVector() {
        BlockState state = this.getBlockState();
        if (!state.is((Block)AllBlocks.DEPLOYER)) {
            return Vec3.ZERO;
        }
        return Vec3.atLowerCornerOf((Vec3i)((Direction)state.getValue(DirectionalKineticBlock.FACING)).getUnitVec3i());
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.state = view.read("State", State.CODEC).orElse(State.WAITING);
        this.mode = view.read("Mode", Mode.CODEC).orElse(Mode.PUNCH);
        this.timer = view.getIntOr("Timer", 0);
        this.redstoneLocked = view.getBooleanOr("Powered", false);
        this.owner = view.read("Owner", UUIDUtil.CODEC).orElse(null);
        this.ownerName = view.read("OwnerName", (Codec)Codec.STRING).orElse(null);
        this.deferredInventoryList = view.read("Inventory", CompoundTag.CODEC).orElseGet(CompoundTag::new);
        this.overflowItems = new ArrayList<ItemStack>();
        view.read("Overflow", CreateCodecs.ITEM_LIST_CODEC).ifPresent(this.overflowItems::addAll);
        view.read("HeldItem", ItemStack.OPTIONAL_CODEC).ifPresent(item -> {
            this.heldItem = item;
        });
        super.read(view, clientPacket);
        if (!clientPacket) {
            return;
        }
        this.fistBump = view.getBooleanOr("Fistbump", false);
        this.reach = view.getFloatOr("Reach", 0.0f);
        view.read("Particle", ItemStack.CODEC).ifPresent(particleStack -> SandPaperItem.spawnParticles(VecHelper.getCenterOf((Vec3i)this.worldPosition).add(this.getMovementVector().scale((double)(this.reach + 1.0f))), particleStack, this.level));
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.store("Mode", Mode.CODEC, (Object)this.mode);
        view.store("State", State.CODEC, (Object)this.state);
        view.putInt("Timer", this.timer);
        view.putBoolean("Powered", this.redstoneLocked);
        if (this.owner != null) {
            view.store("Owner", UUIDUtil.CODEC, (Object)this.owner);
            view.store("OwnerName", (Codec)Codec.STRING, (Object)this.ownerName);
        }
        if (this.player != null) {
            ServerPlayer serverPlayer = this.player.cast();
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(this.problemPath(), Create.LOGGER);){
                TagValueOutput writeView = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)this.level.registryAccess());
                serverPlayer.getInventory().save(writeView.list("Inventory", ItemStackWithSlot.CODEC));
                view.store("Inventory", CompoundTag.CODEC, (Object)writeView.buildResult());
            }
            ItemStack stack = serverPlayer.getMainHandItem();
            view.store("HeldItem", ItemStack.OPTIONAL_CODEC, (Object)stack);
            view.store("Overflow", CreateCodecs.ITEM_LIST_CODEC, this.overflowItems);
        } else if (this.deferredInventoryList != null) {
            view.store("Inventory", CompoundTag.CODEC, (Object)this.deferredInventoryList);
        }
        super.write(view, clientPacket);
        if (!clientPacket) {
            return;
        }
        view.putBoolean("Fistbump", this.fistBump);
        view.putFloat("Reach", this.reach);
        if (this.player == null) {
            return;
        }
        if (this.player.getSpawnedItemEffects() != null) {
            ItemStack stack = this.player.getSpawnedItemEffects();
            if (!stack.isEmpty()) {
                view.store("Particle", ItemStack.CODEC, (Object)stack);
            }
            this.player.setSpawnedItemEffects(null);
        }
    }

    @Override
    public void writeSafe(ValueOutput view) {
        view.store("Mode", Mode.CODEC, (Object)this.mode);
        super.writeSafe(view);
    }

    private Container createHandler() {
        return new DeployerItemHandler(this);
    }

    public void redstoneUpdate() {
        if (this.level.isClientSide()) {
            return;
        }
        boolean blockPowered = this.level.hasNeighborSignal(this.worldPosition);
        if (blockPowered == this.redstoneLocked) {
            return;
        }
        this.redstoneLocked = blockPowered;
        this.sendData();
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(3.0);
    }

    public void discardPlayer() {
        if (this.player == null) {
            return;
        }
        ServerPlayer serverPlayer = this.player.cast();
        serverPlayer.getInventory().dropAll();
        this.overflowItems.forEach(itemstack -> serverPlayer.drop(itemstack, true, false));
        serverPlayer.discard();
        this.player = null;
    }

    public void changeMode() {
        this.mode = this.mode == Mode.PUNCH ? Mode.USE : Mode.PUNCH;
        this.setChanged();
        this.sendData();
    }

    public void setAnimatedOffset(float offset) {
        this.animatedOffset.setValue(offset);
    }

    @Nullable
    public Recipe<? extends RecipeInput> getRecipe(ItemStack stack) {
        if (this.player == null || this.level == null) {
            return null;
        }
        ItemStack heldItemMainhand = this.player.cast().getMainHandItem();
        RecipeMap preparedRecipes = ((ServerLevel)this.level).recipeAccess().recipes;
        if (heldItemMainhand.getItem() instanceof SandPaperItem) {
            return preparedRecipes.getRecipesFor(AllRecipeTypes.SANDPAPER_POLISHING, (RecipeInput)new SingleRecipeInput(stack), this.level).filter(AllRecipeTypes.CAN_BE_AUTOMATED).map(RecipeHolder::value).findFirst().orElse(null);
        }
        ItemApplicationInput input = new ItemApplicationInput(stack, heldItemMainhand);
        return AllRecipeTypes.DEPLOYER_RECIPES.stream().flatMap(type -> preparedRecipes.getRecipesFor(type, (RecipeInput)input, this.level)).filter(AllRecipeTypes.CAN_BE_AUTOMATED).map(RecipeHolder::value).findFirst().orElse(null);
    }

    public DeployerPlayer getPlayer() {
        return this.player;
    }

    public static enum State implements StringRepresentable
    {
        WAITING,
        EXPANDING,
        RETRACTING,
        DUMPING;

        public static final Codec<State> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(State::values);
        }
    }

    public static enum Mode implements StringRepresentable
    {
        PUNCH,
        USE;

        public static final Codec<Mode> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
        }
    }
}

