/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.deployer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.mounted.MountedContraption;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlock;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerHandler;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.schematics.SchematicInstances;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class DeployerMovementBehaviour
extends MovementBehaviour {
    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)DeployerBlock.FACING)).getUnitVec3i()).scale(2.0);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        if (context.world.isClientSide()) {
            return;
        }
        this.tryGrabbingItem(context);
        DeployerPlayer player = this.getPlayer(context);
        DeployerBlockEntity.Mode mode = this.getMode(context);
        if (mode == DeployerBlockEntity.Mode.USE && !DeployerHandler.shouldActivate(player.cast().getMainHandItem(), context.world, pos, null)) {
            return;
        }
        this.activate(context, pos, player, mode);
        this.checkForTrackPlacementAdvancement(context, player);
        this.tryDisposeOfExcess(context);
        context.stall = player.getBlockBreakingProgress() != null;
    }

    public void activate(MovementContext context, BlockPos pos, DeployerPlayer player, DeployerBlockEntity.Mode mode) {
        Level world = context.world;
        player.setPlacedTracks(false);
        FilterItemStack filter = context.getFilterFromBE();
        if (filter.item().is((Item)AllItems.SCHEMATIC)) {
            this.activateAsSchematicPrinter(context, pos, player, world, filter.item());
            return;
        }
        Vec3 facingVec = Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)DeployerBlock.FACING)).getUnitVec3i());
        facingVec = (Vec3)context.rotation.apply(facingVec);
        Vec3 vec = context.position.subtract(facingVec.scale(2.0));
        float xRot = AbstractContraptionEntity.pitchFromVector(facingVec) - 90.0f;
        if (Math.abs(xRot) > 89.0f) {
            Vec3 initial = new Vec3(0.0, 0.0, 1.0);
            AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
            if (abstractContraptionEntity instanceof OrientedContraptionEntity) {
                OrientedContraptionEntity oce = (OrientedContraptionEntity)abstractContraptionEntity;
                initial = VecHelper.rotate(initial, oce.getInitialYaw(), Direction.Axis.Y);
            }
            if ((abstractContraptionEntity = context.contraption.entity) instanceof CarriageContraptionEntity) {
                CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
                initial = VecHelper.rotate(initial, 90.0, Direction.Axis.Y);
            }
            facingVec = (Vec3)context.rotation.apply(initial);
        }
        ServerPlayer serverPlayer = player.cast();
        serverPlayer.setYRot(AbstractContraptionEntity.yawFromVector(facingVec));
        serverPlayer.setXRot(xRot);
        DeployerHandler.activate(player, vec, pos, facingVec, mode);
    }

    protected void checkForTrackPlacementAdvancement(MovementContext context, DeployerPlayer player) {
        if ((context.contraption instanceof MountedContraption || context.contraption instanceof CarriageContraption) && player.getPlacedTracks() && context.blockEntityData != null) {
            context.blockEntityData.read("Owner", UUIDUtil.CODEC).ifPresent(uuid -> {
                Player patt0$temp = context.world.getPlayerByUUID(uuid);
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                    AllAdvancements.SELF_DEPLOYING.trigger(serverPlayer);
                }
            });
        }
    }

    protected void activateAsSchematicPrinter(MovementContext context, BlockPos pos, DeployerPlayer player, Level world, ItemStack filter) {
        ItemStack contextStack;
        if (!filter.has(AllDataComponents.SCHEMATIC_ANCHOR)) {
            return;
        }
        if (!world.getBlockState(pos).canBeReplaced()) {
            return;
        }
        if (!((Boolean)filter.getOrDefault(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)false)).booleanValue()) {
            return;
        }
        SchematicLevel schematicWorld = SchematicInstances.get(world, filter);
        if (schematicWorld == null) {
            return;
        }
        if (!schematicWorld.getBounds().isInside((Vec3i)pos.subtract((Vec3i)schematicWorld.anchor))) {
            return;
        }
        BlockState blockState = schematicWorld.getBlockState(pos);
        ItemRequirement requirement = ItemRequirement.of(blockState, schematicWorld.getBlockEntity(pos));
        if (requirement.isInvalid() || requirement.isEmpty()) {
            return;
        }
        if (blockState.is((Block)AllBlocks.BELT)) {
            return;
        }
        List<ItemRequirement.StackRequirement> requiredItems = requirement.getRequiredItems();
        ItemStack itemStack = contextStack = requiredItems.isEmpty() ? ItemStack.EMPTY : requiredItems.getFirst().stack;
        if (!context.contraption.hasUniversalCreativeCrate) {
            CombinedInvWrapper itemHandler = context.contraption.getStorage().getAllItems();
            for (ItemRequirement.StackRequirement required : requiredItems) {
                int count = required.stack.getCount();
                int extract = itemHandler.countAll(required::matches, count);
                if (extract == count) continue;
                return;
            }
            for (ItemRequirement.StackRequirement required : requiredItems) {
                contextStack = required.stack;
                itemHandler.extractAll(required::matches, contextStack.getCount());
            }
        }
        CompoundTag data = BlockHelper.prepareBlockEntityData(world, blockState, schematicWorld.getBlockEntity(pos));
        BlockHelper.placeSchematicBlock(world, blockState, pos, contextStack, data);
        if (blockState.getBlock() instanceof BaseRailBlock || blockState.getBlock() instanceof ITrackBlock) {
            player.setPlacedTracks(true);
        }
    }

    @Override
    public void tick(MovementContext context) {
        if (context.world.isClientSide()) {
            return;
        }
        if (!context.stall) {
            return;
        }
        DeployerPlayer player = this.getPlayer(context);
        DeployerBlockEntity.Mode mode = this.getMode(context);
        Pair<BlockPos, Float> blockBreakingProgress = player.getBlockBreakingProgress();
        if (blockBreakingProgress != null) {
            int timer = context.data.getIntOr("Timer", 0);
            if (timer < 20) {
                context.data.putInt("Timer", ++timer);
                return;
            }
            context.data.remove("Timer");
            this.activate(context, (BlockPos)blockBreakingProgress.getKey(), player, mode);
            this.tryDisposeOfExcess(context);
        }
        context.stall = player.getBlockBreakingProgress() != null;
    }

    @Override
    public void cancelStall(MovementContext context) {
        if (context.world.isClientSide()) {
            return;
        }
        super.cancelStall(context);
        DeployerPlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        if (player.getBlockBreakingProgress() == null) {
            return;
        }
        context.world.destroyBlockProgress(player.cast().getId(), (BlockPos)player.getBlockBreakingProgress().getKey(), -1);
        player.setBlockBreakingProgress(null);
    }

    @Override
    public void stopMoving(MovementContext context) {
        if (context.world.isClientSide()) {
            return;
        }
        DeployerPlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        ServerPlayer serverPlayer = player.cast();
        this.cancelStall(context);
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(context.contraption.entity.problemPath(), Create.LOGGER);){
            TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)context.world.registryAccess());
            serverPlayer.getInventory().save(view.list("Inventory", ItemStackWithSlot.CODEC));
            context.blockEntityData.store("Inventory", CompoundTag.CODEC, (Object)view.buildResult());
        }
        serverPlayer.discard();
    }

    private void tryGrabbingItem(MovementContext context) {
        DeployerPlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        ServerPlayer serverPlayer = player.cast();
        if (serverPlayer.getMainHandItem().isEmpty()) {
            FilterItemStack filter = context.getFilterFromBE();
            if (filter.item().is((Item)AllItems.SCHEMATIC)) {
                return;
            }
            ItemStack held = context.contraption.getStorage().getAllItems().extract(stack -> filter.test(context.world, (ItemStack)stack), 1);
            serverPlayer.setItemInHand(InteractionHand.MAIN_HAND, held);
        }
    }

    private void tryDisposeOfExcess(MovementContext context) {
        DeployerPlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        Inventory inv = player.cast().getInventory();
        FilterItemStack filter = context.getFilterFromBE();
        NonNullList main = inv.getNonEquipmentItems();
        int selected = inv.getSelectedSlot();
        for (int i = 0; i < main.size(); ++i) {
            ItemStack stack = (ItemStack)main.get(i);
            if (stack.isEmpty() || i == selected && filter.test(context.world, stack)) continue;
            this.dropItem(context, stack);
            main.set(i, (Object)ItemStack.EMPTY);
        }
        Inventory.EQUIPMENT_SLOT_MAPPING.forEach((slot, equipmentSlot) -> {
            ItemStack stack = inv.getItem(slot);
            if (stack.isEmpty()) {
                return;
            }
            this.dropItem(context, stack);
            inv.setItem(slot, ItemStack.EMPTY);
        });
    }

    @Override
    public void writeExtraData(MovementContext context) {
        DeployerPlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        ItemStack stack = player.cast().getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        RegistryOps ops = context.world.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        context.data.store("HeldItem", ItemStack.CODEC, (DynamicOps)ops, (Object)stack);
    }

    private DeployerPlayer getPlayer(MovementContext context) {
        if (!(context.temporaryData instanceof DeployerPlayer) && context.world instanceof ServerLevel) {
            RegistryAccess registryManager = context.world.registryAccess();
            UUID owner = context.blockEntityData.read("Owner", UUIDUtil.CODEC).orElse(null);
            String ownerName = context.blockEntityData.read("OwnerName", (Codec)Codec.STRING).orElse(null);
            DeployerPlayer player = DeployerPlayer.create((ServerLevel)context.world, owner, ownerName);
            player.setOnMinecartContraption(context.contraption instanceof MountedContraption);
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "DeployerMovementBehaviour", Create.LOGGER);){
                CompoundTag inventory = context.blockEntityData.read("Inventory", CompoundTag.CODEC).orElseGet(CompoundTag::new);
                ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)registryManager, (CompoundTag)inventory);
                player.cast().getInventory().load(view.listOrEmpty("Inventory", ItemStackWithSlot.CODEC));
            }
            if (context.data.contains("HeldItem")) {
                player.cast().setItemInHand(InteractionHand.MAIN_HAND, context.data.read("HeldItem", ItemStack.CODEC, (DynamicOps)registryManager.createSerializationContext((DynamicOps)NbtOps.INSTANCE)).orElse(ItemStack.EMPTY));
            }
            context.blockEntityData.remove("Inventory");
            context.temporaryData = player;
        }
        return (DeployerPlayer)context.temporaryData;
    }

    private DeployerBlockEntity.Mode getMode(MovementContext context) {
        return context.blockEntityData.read("Mode", DeployerBlockEntity.Mode.CODEC).orElse(DeployerBlockEntity.Mode.PUNCH);
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }
}

