/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.deployer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.mounted.MountedContraption;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerFakePlayer;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.apache.commons.lang3.tuple.MutablePair;

public class DeployerMovingInteraction
extends MovingInteractionBehaviour {
    @Override
    public boolean handlePlayerInteraction(Player player, InteractionHand activeHand, BlockPos localPos, AbstractContraptionEntity contraptionEntity) {
        MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> actor = contraptionEntity.getContraption().getActorAt(localPos);
        if (actor == null || actor.right == null) {
            return false;
        }
        MovementContext ctx = (MovementContext)actor.right;
        ItemStack heldStack = player.getItemInHand(activeHand);
        if (heldStack.is((Item)AllItems.WRENCH)) {
            DeployerBlockEntity.Mode mode = ctx.blockEntityData.read("Mode", DeployerBlockEntity.Mode.CODEC).orElse(DeployerBlockEntity.Mode.PUNCH);
            ctx.blockEntityData.store("Mode", DeployerBlockEntity.Mode.CODEC, (Object)(mode == DeployerBlockEntity.Mode.PUNCH ? DeployerBlockEntity.Mode.USE : DeployerBlockEntity.Mode.PUNCH));
        } else {
            DeployerPlayer fake;
            if (ctx.world.isClientSide()) {
                return true;
            }
            if (!(ctx.temporaryData instanceof DeployerFakePlayer) && ctx.world instanceof ServerLevel) {
                UUID owner = ctx.blockEntityData.read("Owner", UUIDUtil.CODEC).orElse(null);
                String ownerName = ctx.blockEntityData.read("Owner", (Codec)Codec.STRING).orElse(null);
                DeployerPlayer deployerFakePlayer = DeployerPlayer.create((ServerLevel)ctx.world, owner, ownerName);
                deployerFakePlayer.setOnMinecartContraption(ctx.contraption instanceof MountedContraption);
                try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(contraptionEntity.problemPath(), Create.LOGGER);){
                    CompoundTag inventory = ctx.blockEntityData.read("Inventory", CompoundTag.CODEC).orElseGet(CompoundTag::new);
                    ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)ctx.world.registryAccess(), (CompoundTag)inventory);
                    deployerFakePlayer.cast().getInventory().load(view.listOrEmpty("Inventory", ItemStackWithSlot.CODEC));
                }
                fake = deployerFakePlayer;
                ctx.temporaryData = fake;
                ctx.blockEntityData.remove("Inventory");
            } else {
                fake = (DeployerPlayer)ctx.temporaryData;
            }
            if (fake == null) {
                return false;
            }
            ServerPlayer serverPlayer = fake.cast();
            ItemStack deployerItem = serverPlayer.getMainHandItem();
            player.setItemInHand(activeHand, deployerItem.copy());
            serverPlayer.setItemInHand(InteractionHand.MAIN_HAND, heldStack.copy());
            if (!heldStack.isEmpty()) {
                RegistryOps ops = player.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
                ctx.blockEntityData.store("HeldItem", ItemStack.CODEC, (DynamicOps)ops, (Object)heldStack);
                ctx.data.store("HeldItem", ItemStack.CODEC, (DynamicOps)ops, (Object)heldStack);
            }
        }
        return true;
    }
}

