/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.gantry;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlock;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GantryShaftBlockEntity
extends KineticBlockEntity {
    public GantryShaftBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.GANTRY_SHAFT, pos, state);
    }

    @Override
    protected boolean syncSequenceContext() {
        return true;
    }

    public void checkAttachedCarriageBlocks() {
        if (!this.canAssembleOn()) {
            return;
        }
        for (Direction d : Iterate.directions) {
            BlockEntity blockEntity;
            BlockPos offset;
            BlockState pinionState;
            if (d.getAxis() == ((Direction)this.getBlockState().getValue((Property)GantryShaftBlock.FACING)).getAxis() || !(pinionState = this.level.getBlockState(offset = this.worldPosition.relative(d))).is((Block)AllBlocks.GANTRY_CARRIAGE) || pinionState.getValue((Property)GantryCarriageBlock.FACING) != d || !((blockEntity = this.level.getBlockEntity(offset)) instanceof GantryCarriageBlockEntity)) continue;
            ((GantryCarriageBlockEntity)blockEntity).queueAssembly();
        }
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        this.checkAttachedCarriageBlocks();
    }

    @Override
    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        float defaultModifier = super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
        if (connectedViaAxes) {
            return defaultModifier;
        }
        if (!((Boolean)stateFrom.getValue((Property)GantryShaftBlock.POWERED)).booleanValue()) {
            return defaultModifier;
        }
        if (!stateTo.is((Block)AllBlocks.GANTRY_CARRIAGE)) {
            return defaultModifier;
        }
        Direction direction = Direction.getApproximateNearest((float)diff.getX(), (float)diff.getY(), (float)diff.getZ());
        if (stateTo.getValue((Property)GantryCarriageBlock.FACING) != direction) {
            return defaultModifier;
        }
        return GantryCarriageBlockEntity.getGantryPinionModifier((Direction)stateFrom.getValue((Property)GantryShaftBlock.FACING), (Direction)stateTo.getValue((Property)GantryCarriageBlock.FACING));
    }

    @Override
    public boolean isCustomConnection(KineticBlockEntity other, BlockState state, BlockState otherState) {
        if (!otherState.is((Block)AllBlocks.GANTRY_CARRIAGE)) {
            return false;
        }
        BlockPos diff = other.getBlockPos().subtract((Vec3i)this.worldPosition);
        Direction direction = Direction.getApproximateNearest((float)diff.getX(), (float)diff.getY(), (float)diff.getZ());
        return otherState.getValue((Property)GantryCarriageBlock.FACING) == direction;
    }

    public boolean canAssembleOn() {
        BlockState blockState = this.getBlockState();
        if (blockState.getBlock() != AllBlocks.GANTRY_SHAFT) {
            return false;
        }
        if (((Boolean)blockState.getValue((Property)GantryShaftBlock.POWERED)).booleanValue()) {
            return false;
        }
        float speed = this.getPinionMovementSpeed();
        switch ((GantryShaftBlock.Part)((Object)blockState.getValue(GantryShaftBlock.PART))) {
            case END: {
                return speed < 0.0f;
            }
            case MIDDLE: {
                return speed != 0.0f;
            }
            case START: {
                return speed > 0.0f;
            }
        }
        return false;
    }

    public float getPinionMovementSpeed() {
        BlockState blockState = this.getBlockState();
        if (blockState.getBlock() != AllBlocks.GANTRY_SHAFT) {
            return 0.0f;
        }
        return Mth.clamp((float)GantryShaftBlockEntity.convertToLinear(-this.getSpeed()), (float)-0.49f, (float)0.49f);
    }

    @Override
    public boolean isNoisy() {
        return false;
    }
}

