/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.gauge;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.gauge.GaugeBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;

public class SpeedGaugeBlockEntity
extends GaugeBlockEntity {
    public SpeedGaugeBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.SPEEDOMETER, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        float speed = Math.abs(this.getSpeed());
        this.dialTarget = SpeedGaugeBlockEntity.getDialTarget(speed);
        this.color = Color.mixColors(IRotate.SpeedLevel.of(speed).getColor(), 0xFFFFFF, 0.25f);
        this.setChanged();
    }

    public static float getDialTarget(float speed) {
        speed = Math.abs(speed);
        float medium = ((Float)AllConfigs.server().kinetics.mediumSpeed.get()).floatValue();
        float fast = ((Float)AllConfigs.server().kinetics.fastSpeed.get()).floatValue();
        float max = ((Integer)AllConfigs.server().kinetics.maxRotationSpeed.get()).floatValue();
        float target = speed == 0.0f ? 0.0f : (speed < medium ? Mth.lerp((float)(speed / medium), (float)0.0f, (float)0.45f) : (speed < fast ? Mth.lerp((float)((speed - medium) / (fast - medium)), (float)0.45f, (float)0.75f) : Mth.lerp((float)((speed - fast) / (max - fast)), (float)0.75f, (float)1.125f)));
        return target;
    }
}

