/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mixer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.basin.BasinRecipe;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.ArrayDeque;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record MixingRecipe(ItemStack result, FluidStack fluidResult, HeatCondition heat, List<FluidIngredient> fluidIngredients, List<SizedIngredient> ingredients) implements BasinRecipe
{
    @Override
    public int getIngredientSize() {
        return this.fluidIngredients.size() + this.ingredients().size();
    }

    @Override
    public List<SizedIngredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return this.fluidIngredients;
    }

    public boolean matches(BasinInput input, Level world) {
        if (!this.heat.testBlazeBurner(input.heat())) {
            return false;
        }
        List<ItemStack> outputs = BasinRecipe.tryCraft(input, this.ingredients);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.matchFluidIngredient(input, this.fluidIngredients)) {
            return false;
        }
        if (!this.result.isEmpty()) {
            outputs.add(this.result);
        }
        List<FluidStack> fluids = this.fluidResult.isEmpty() ? List.of() : List.of(this.fluidResult);
        return input.acceptOutputs(outputs, fluids, true);
    }

    @Override
    public boolean apply(BasinInput input) {
        List<FluidStack> fluids;
        if (!this.heat.testBlazeBurner(input.heat())) {
            return false;
        }
        ArrayDeque<Runnable> changes = new ArrayDeque<Runnable>();
        List<ItemStack> outputs = BasinRecipe.prepareCraft(input, this.ingredients, changes);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.prepareFluidCraft(input, this.fluidIngredients, changes)) {
            return false;
        }
        if (!this.result.isEmpty()) {
            outputs.add(this.result);
        }
        List<FluidStack> list = fluids = this.fluidResult.isEmpty() ? List.of() : List.of(this.fluidResult);
        if (!input.acceptOutputs(outputs, fluids, true)) {
            return false;
        }
        changes.forEach(Runnable::run);
        return input.acceptOutputs(outputs, fluids, false);
    }

    public RecipeSerializer<MixingRecipe> getSerializer() {
        return AllRecipeSerializers.MIXING;
    }

    public RecipeType<MixingRecipe> getType() {
        return AllRecipeTypes.MIXING;
    }

    public static class Serializer
    implements RecipeSerializer<MixingRecipe> {
        public static final MapCodec<MixingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.optionalFieldOf("result", (Object)ItemStack.EMPTY).forGetter(MixingRecipe::result), (App)FluidStack.CODEC.optionalFieldOf("fluid_result", (Object)FluidStack.EMPTY).forGetter(MixingRecipe::fluidResult), (App)HeatCondition.CODEC.optionalFieldOf("heat_requirement", (Object)HeatCondition.NONE).forGetter(MixingRecipe::heat), (App)FluidIngredient.CODEC.listOf(1, 2).optionalFieldOf("fluid_ingredients", List.of()).forGetter(MixingRecipe::fluidIngredients), (App)SizedIngredient.getListCodec(1, 4).optionalFieldOf("ingredients", List.of()).forGetter(MixingRecipe::ingredients)).apply((Applicative)instance, MixingRecipe::new)).validate(recipe -> {
            if (recipe.result.isEmpty() && recipe.fluidResult.isEmpty()) {
                return DataResult.error(() -> "MixingRecipe must have a result or a fluid result");
            }
            if (recipe.fluidIngredients.isEmpty() && recipe.ingredients.isEmpty()) {
                return DataResult.error(() -> "MixingRecipe must have a ingredient or a fluid ingredient");
            }
            return DataResult.success((Object)recipe);
        });
        private static final StreamCodec<RegistryFriendlyByteBuf, MixingRecipe> PACKET_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, MixingRecipe::result, FluidStack.OPTIONAL_PACKET_CODEC, MixingRecipe::fluidResult, HeatCondition.PACKET_CODEC, MixingRecipe::heat, (StreamCodec)FluidIngredient.PACKET_CODEC.apply(ByteBufCodecs.list()), MixingRecipe::fluidIngredients, (StreamCodec)SizedIngredient.PACKET_CODEC.apply(ByteBufCodecs.list()), MixingRecipe::ingredients, MixingRecipe::new);

        public MapCodec<MixingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MixingRecipe> streamCodec() {
            return PACKET_CODEC;
        }
    }
}

