/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.saw;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.BlockBreakingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.saw.CuttingRecipe;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import com.zurrtum.create.content.kinetics.saw.TreeCutter;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.recipe.RecipeFinder;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SawBlockEntity
extends BlockBreakingKineticBlockEntity {
    private static final Object cuttingRecipesKey = new Object();
    public ProcessingInventory inventory;
    private int recipeIndex;
    private ServerFilteringBehaviour filtering;
    public ItemStack playEvent;

    public SawBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.SAW, pos, state);
        this.inventory = new ProcessingInventory(this::start, direction -> direction != Direction.DOWN).withSlotLimit((Boolean)AllConfigs.server().recipes.bulkCutting.get() == false);
        this.inventory.remainingTime = -1.0f;
        this.recipeIndex = 0;
        this.playEvent = ItemStack.EMPTY;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new ServerFilteringBehaviour(this).forRecipes();
        behaviours.add(this.filtering);
        behaviours.add(new DirectBeltInputBehaviour(this).allowingBeltFunnelsWhen(this::canProcess));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.SAW_PROCESSING);
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        this.inventory.write(view);
        view.putInt("RecipeIndex", this.recipeIndex);
        super.write(view, clientPacket);
        if (!clientPacket || this.playEvent.isEmpty()) {
            return;
        }
        view.store("PlayEvent", ItemStack.CODEC, (Object)this.playEvent);
        this.playEvent = ItemStack.EMPTY;
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.inventory.read(view);
        this.recipeIndex = view.getIntOr("RecipeIndex", 0);
        this.playEvent = view.read("PlayEvent", ItemStack.CODEC).orElse(ItemStack.EMPTY);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(this.getBlockPos()).inflate(0.125);
    }

    @Override
    public void tick() {
        if (this.shouldRun() && this.ticksUntilNextProgress < 0) {
            this.destroyNextTick();
        }
        super.tick();
        if (!this.canProcess()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.remainingTime == -1.0f) {
            if (!this.inventory.isEmpty() && !this.inventory.appliedRecipe) {
                this.start(this.inventory.getItem(0));
            }
            return;
        }
        float processingSpeed = Mth.clamp((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
        this.inventory.remainingTime -= processingSpeed;
        if (this.inventory.remainingTime > 0.0f) {
            this.spawnParticles(this.inventory.getItem(0));
        }
        if (this.inventory.remainingTime < 5.0f && !this.inventory.appliedRecipe) {
            if (this.level.isClientSide()) {
                return;
            }
            this.playEvent = this.inventory.getItem(0);
            this.applyRecipe();
            this.inventory.appliedRecipe = true;
            this.inventory.recipeDuration = 20.0f;
            this.inventory.remainingTime = 20.0f;
            this.sendData();
            return;
        }
        if (this.inventory.remainingTime > 0.0f) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        Vec3 itemMovement = this.getItemMovementVec();
        Direction itemMovementFacing = Direction.getApproximateNearest((double)itemMovement.x, (double)itemMovement.y, (double)itemMovement.z);
        int size = this.inventory.getContainerSize();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack tryExportingToBeltFunnel;
            ItemStack stack = this.inventory.getItem(slot);
            if (stack.isEmpty() || (tryExportingToBeltFunnel = this.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(this.inventory.onExtract(stack.copy()), itemMovementFacing.getOpposite(), false)) == null) continue;
            int count = tryExportingToBeltFunnel.getCount();
            if (count != stack.getCount()) {
                if (count == 0) {
                    this.inventory.setItem(slot, ItemStack.EMPTY);
                } else {
                    stack.setCount(count);
                }
                this.notifyUpdate();
                return;
            }
            if (tryExportingToBeltFunnel.isEmpty()) continue;
            return;
        }
        BlockPos nextPos = this.worldPosition.offset((Vec3i)BlockPos.containing((Position)itemMovement));
        DirectBeltInputBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)this.level, nextPos, DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing)) {
                return;
            }
            if (this.level.isClientSide()) {
                return;
            }
            int size2 = this.inventory.getContainerSize();
            for (int slot = 0; slot < size2; ++slot) {
                ItemStack remainder;
                int count;
                ItemStack stack = this.inventory.getItem(slot);
                if (stack.isEmpty() || (count = (remainder = behaviour.handleInsertion(this.inventory.onExtract(stack.copy()), itemMovementFacing, false)).getCount()) == stack.getCount()) continue;
                if (count == 0) {
                    this.inventory.setItem(slot, ItemStack.EMPTY);
                } else {
                    stack.setCount(count);
                }
                changed = true;
            }
            if (changed) {
                this.setChanged();
                this.sendData();
            }
            return;
        }
        Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(itemMovement.scale(0.5).add(0.0, 0.5, 0.0));
        Vec3 outMotion = itemMovement.scale(0.0625).add(0.0, 0.125, 0.0);
        int size3 = this.inventory.getContainerSize();
        for (int slot = 0; slot < size3; ++slot) {
            ItemStack stack = this.inventory.getItem(slot);
            if (stack.isEmpty()) continue;
            ItemEntity entityIn = new ItemEntity(this.level, outPos.x, outPos.y, outPos.z, this.inventory.onExtract(stack));
            entityIn.setDeltaMovement(outMotion);
            this.level.addFreshEntity((Entity)entityIn);
        }
        this.inventory.clearContent();
        this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
        this.inventory.remainingTime = -1.0f;
        this.sendData();
    }

    @Override
    public void destroy() {
        super.destroy();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)this.inventory);
    }

    public void spawnEventParticles(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        Object particleData = null;
        particleData = stack.getItem() instanceof BlockItem ? new BlockParticleOption(ParticleTypes.BLOCK, ((BlockItem)stack.getItem()).getBlock().defaultBlockState()) : new ItemParticleOption(ParticleTypes.ITEM, stack);
        RandomSource r = this.level.random;
        Vec3 v = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(0.0, 0.3125, 0.0);
        for (int i = 0; i < 10; ++i) {
            Vec3 m = VecHelper.offsetRandomly(new Vec3(0.0, 0.25, 0.0), r, 0.125f);
            this.level.addParticle((ParticleOptions)particleData, v.x, v.y, v.z, m.x, m.y, m.y);
        }
    }

    protected void spawnParticles(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        ItemParticleOption particleData = null;
        float speed = 1.0f;
        if (stack.getItem() instanceof BlockItem) {
            particleData = new BlockParticleOption(ParticleTypes.BLOCK, ((BlockItem)stack.getItem()).getBlock().defaultBlockState());
        } else {
            particleData = new ItemParticleOption(ParticleTypes.ITEM, stack);
            speed = 0.125f;
        }
        RandomSource r = this.level.random;
        Vec3 vec = this.getItemMovementVec();
        Vec3 pos = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        float offset = this.inventory.recipeDuration != 0.0f ? this.inventory.remainingTime / this.inventory.recipeDuration : 0.0f;
        offset /= 2.0f;
        if (this.inventory.appliedRecipe) {
            offset -= 0.5f;
        }
        this.level.addParticle((ParticleOptions)particleData, pos.x() + -vec.x * (double)offset, pos.y() + (double)0.45f, pos.z() + -vec.z * (double)offset, -vec.x * (double)speed, (double)(r.nextFloat() * speed), -vec.z * (double)speed);
    }

    public Vec3 getItemMovementVec() {
        boolean alongX = (Boolean)this.getBlockState().getValue((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
        int offset = this.getSpeed() < 0.0f ? -1 : 1;
        return new Vec3((double)(offset * (alongX ? 1 : 0)), 0.0, (double)(offset * (alongX ? 0 : -1)));
    }

    private void applyRecipe() {
        ItemStack recipeRemainder;
        ItemStack stack = this.inventory.getItem(0);
        if (PackageItem.isPackage(stack)) {
            this.inventory.clearContent();
            this.inventory.outputAllowInsertion();
            ItemContainerContents contents = (ItemContainerContents)stack.getOrDefault(AllDataComponents.PACKAGE_CONTENTS, (Object)ItemContainerContents.EMPTY);
            this.inventory.insert(contents.stream().toList());
            this.inventory.outputForbidInsertion();
            return;
        }
        SingleRecipeInput input = new SingleRecipeInput(stack);
        Pair<Recipe<SingleRecipeInput>, ItemStack> pair = this.updateRecipe(input, false);
        if (pair == null) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        this.inventory.recipeDuration = 0.0f;
        this.inventory.appliedRecipe = false;
        this.inventory.setItem(0, ItemStack.EMPTY);
        ItemStack output = pair.getSecond();
        if (output == null) {
            output = pair.getFirst().assemble((RecipeInput)input, (HolderLookup.Provider)this.level.registryAccess());
        }
        List<ItemStack> list = (recipeRemainder = stack.getItem().getCraftingRemainder()).isEmpty() ? ItemHelper.multipliedOutput(output, stack.getCount()) : ItemHelper.multipliedOutput(List.of(output, recipeRemainder), stack.getCount());
        int listSize = list.size();
        int invSize = this.inventory.getContainerSize();
        for (int slot = 1; slot < invSize; ++slot) {
            this.inventory.setItem(slot, slot <= listSize ? list.get(slot - 1) : ItemStack.EMPTY);
        }
        this.award(AllAdvancements.SAW_PROCESSING);
    }

    private static boolean matchCuttingRecipe(RecipeHolder<? extends Recipe<?>> entry) {
        return entry.value().getType() == AllRecipeTypes.CUTTING && !AllRecipeTypes.shouldIgnoreInAutomation(entry);
    }

    private static boolean matchAllRecipe(RecipeHolder<? extends Recipe<?>> entry) {
        RecipeType type = entry.value().getType();
        return (type == AllRecipeTypes.CUTTING || type == RecipeType.STONECUTTING) && !AllRecipeTypes.shouldIgnoreInAutomation(entry);
    }

    @Nullable
    private Pair<Recipe<SingleRecipeInput>, ItemStack> updateRecipe(SingleRecipeInput input, boolean plus) {
        List<RecipeHolder<?>> startedSearch = RecipeFinder.get(cuttingRecipesKey, (ServerLevel)this.level, (Boolean)AllConfigs.server().recipes.allowStonecuttingOnSaw.get() != false ? SawBlockEntity::matchAllRecipe : SawBlockEntity::matchCuttingRecipe);
        int index = 0;
        Recipe first = null;
        if (this.filtering.getFilter().isEmpty()) {
            for (RecipeHolder<?> entry : startedSearch) {
                Recipe recipe = entry.value();
                if (!recipe.matches((RecipeInput)input, this.level)) continue;
                if (first == null) {
                    first = recipe;
                }
                if (index == this.recipeIndex) {
                    if (plus) {
                        ++this.recipeIndex;
                    }
                    return Pair.of(recipe, null);
                }
                ++index;
            }
        } else {
            RegistryAccess registryManager = this.level.registryAccess();
            for (RecipeHolder<?> entry : startedSearch) {
                ItemStack output;
                Recipe recipe = entry.value();
                if (!recipe.matches((RecipeInput)input, this.level) || !this.filtering.test(output = recipe.assemble((RecipeInput)input, (HolderLookup.Provider)registryManager))) continue;
                return Pair.of(recipe, output);
            }
        }
        this.recipeIndex = 0;
        return first == null ? null : Pair.of(first, null);
    }

    public void insertItem(ItemEntity entity) {
        if (!this.canProcess()) {
            return;
        }
        if (!this.inventory.isEmpty()) {
            return;
        }
        if (!entity.isAlive()) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        this.inventory.clearContent();
        ItemStack stack = entity.getItem();
        int count = stack.getCount();
        int insert = this.inventory.insert(stack);
        if (insert == count) {
            entity.discard();
        } else if (insert != 0) {
            stack.shrink(insert);
            entity.setItem(stack);
        }
    }

    public void start(ItemStack inserted) {
        if (!this.canProcess()) {
            return;
        }
        if (this.inventory.isEmpty()) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        SingleRecipeInput input = new SingleRecipeInput(this.inventory.getItem(0));
        Pair<Recipe<SingleRecipeInput>, ItemStack> pair = this.updateRecipe(input, true);
        int time = 50;
        if (pair == null) {
            this.inventory.recipeDuration = 10.0f;
            this.inventory.remainingTime = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        Recipe<SingleRecipeInput> recipe = pair.getFirst();
        if (recipe instanceof CuttingRecipe) {
            CuttingRecipe cuttingRecipe = (CuttingRecipe)recipe;
            time = cuttingRecipe.time();
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, inserted.getCount() / 5));
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    protected boolean canProcess() {
        return this.getBlockState().getValue((Property)SawBlock.FACING) == Direction.UP;
    }

    @Override
    protected boolean shouldRun() {
        return ((Direction)this.getBlockState().getValue((Property)SawBlock.FACING)).getAxis().isHorizontal();
    }

    @Override
    protected BlockPos getBreakingPos() {
        return this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)SawBlock.FACING));
    }

    @Override
    public void onBlockBroken(BlockState stateToBreak) {
        super.onBlockBroken(stateToBreak);
        TreeCutter.findTree((BlockGetter)this.level, this.breakingPos, stateToBreak).destroyBlocks(this.level, null, this::dropItemFromCutTree);
    }

    public void dropItemFromCutTree(BlockPos pos, ItemStack stack) {
        float distance = (float)Math.sqrt(pos.distSqr((Vec3i)this.breakingPos));
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        ItemEntity entity = new ItemEntity(this.level, dropPos.x, dropPos.y, dropPos.z, stack);
        entity.setDeltaMovement(Vec3.atLowerCornerOf((Vec3i)this.breakingPos.subtract((Vec3i)pos)).scale((double)(distance / 20.0f)));
        this.level.addFreshEntity((Entity)entity);
    }

    @Override
    public boolean canBreak(BlockState stateToBreak, float blockHardness) {
        boolean sawable = SawBlockEntity.isSawable(stateToBreak);
        return super.canBreak(stateToBreak, blockHardness) && sawable;
    }

    public static boolean isSawable(BlockState stateToBreak) {
        if (stateToBreak.is(BlockTags.SAPLINGS)) {
            return false;
        }
        if (TreeCutter.isLog(stateToBreak) || stateToBreak.is(BlockTags.LEAVES)) {
            return true;
        }
        if (TreeCutter.isRoot(stateToBreak)) {
            return true;
        }
        Block block = stateToBreak.getBlock();
        if (block instanceof BambooStalkBlock) {
            return true;
        }
        if (block.equals(Blocks.PUMPKIN) || block.equals(Blocks.MELON)) {
            return true;
        }
        if (block instanceof CactusBlock) {
            return true;
        }
        if (block instanceof SugarCaneBlock) {
            return true;
        }
        if (block instanceof KelpPlantBlock) {
            return true;
        }
        if (block instanceof KelpBlock) {
            return true;
        }
        return block instanceof ChorusPlantBlock;
    }
}

