/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.simpleRelays;

import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class CogwheelBlockItem
extends BlockItem {
    boolean large;
    private final int placementHelperId;
    private final int integratedCogHelperId;

    public CogwheelBlockItem(CogWheelBlock block, Item.Properties builder) {
        super((Block)block, builder);
        this.large = block.isLarge;
        this.placementHelperId = PlacementHelpers.register(this.large ? new LargeCogHelper() : new SmallCogHelper());
        this.integratedCogHelperId = PlacementHelpers.register(this.large ? new IntegratedLargeCogHelper() : new IntegratedSmallCogHelper());
    }

    public static InteractionResult onItemUseFirst(Level world, Player player, ItemStack stack, InteractionHand hand, BlockHitResult ray, BlockPos pos) {
        Item item = stack.getItem();
        if (item instanceof CogwheelBlockItem) {
            BlockState state;
            CogwheelBlockItem item2 = (CogwheelBlockItem)item;
            IPlacementHelper helper = PlacementHelpers.get(item2.placementHelperId);
            if (helper.matchesState(state = world.getBlockState(pos)) && player != null && !player.isShiftKeyDown()) {
                InteractionResult result = helper.getOffset(player, world, state, pos, ray).placeInWorld(world, item2, player, hand);
                if (result != InteractionResult.TRY_WITH_EMPTY_HAND) {
                    return result;
                }
            } else if (item2.integratedCogHelperId != -1 && (helper = PlacementHelpers.get(item2.integratedCogHelperId)).matchesState(state) && player != null && !player.isShiftKeyDown()) {
                return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, item2, player, hand);
            }
        }
        return null;
    }

    private static class LargeCogHelper
    extends DiagonalCogHelper {
        private LargeCogHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (ICogWheel.isLargeCog(state)) {
                Direction.Axis axis = ((IRotate)state.getBlock()).getRotationAxis(state);
                Direction side = IPlacementHelper.orderedByDistanceOnlyAxis(pos, ray.getLocation(), axis).get(0);
                List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.getLocation(), axis);
                for (Direction dir : directions) {
                    BlockPos newPos = pos.relative(dir).relative(side);
                    if (!CogWheelBlock.isValidCogwheelPosition(true, (LevelReader)world, newPos, dir.getAxis()) || !world.getBlockState(newPos).canBeReplaced()) continue;
                    return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.setValue((Property)BlockStateProperties.AXIS, (Comparable)dir.getAxis()));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, world, state, pos, ray);
        }
    }

    private static class SmallCogHelper
    extends DiagonalCogHelper {
        private SmallCogHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (!ICogWheel.isLargeCog(state)) {
                Direction.Axis axis = ((IRotate)state.getBlock()).getRotationAxis(state);
                List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.getLocation(), axis);
                for (Direction dir : directions) {
                    BlockPos newPos = pos.relative(dir);
                    if (!CogWheelBlock.isValidCogwheelPosition(false, (LevelReader)world, newPos, axis) || !world.getBlockState(newPos).canBeReplaced()) continue;
                    return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.setValue((Property)BlockStateProperties.AXIS, (Comparable)axis));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, world, state, pos, ray);
        }
    }

    public static class IntegratedLargeCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> !ICogWheel.isDedicatedCogWheel(s.getBlock()) && ICogWheel.isSmallCog(s);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction face = ray.getDirection();
            Direction.Axis newAxis = state.hasProperty(HorizontalKineticBlock.HORIZONTAL_FACING) ? ((Direction)state.getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getAxis() : (state.hasProperty(DirectionalKineticBlock.FACING) ? ((Direction)state.getValue(DirectionalKineticBlock.FACING)).getAxis() : (state.hasProperty(RotatedPillarKineticBlock.AXIS) ? (Direction.Axis)state.getValue(RotatedPillarKineticBlock.AXIS) : Direction.Axis.Y));
            if (face.getAxis() == newAxis) {
                return PlacementOffset.fail();
            }
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.getLocation(), face.getAxis(), newAxis);
            for (Direction d : directions) {
                BlockPos newPos = pos.relative(face).relative(d);
                if (!world.getBlockState(newPos).canBeReplaced()) continue;
                if (!CogWheelBlock.isValidCogwheelPosition(false, (LevelReader)world, newPos, newAxis)) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.setValue((Property)CogWheelBlock.AXIS, (Comparable)newAxis));
            }
            return PlacementOffset.fail();
        }
    }

    public static class IntegratedSmallCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> !ICogWheel.isDedicatedCogWheel(s.getBlock()) && ICogWheel.isSmallCog(s);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction face = ray.getDirection();
            Direction.Axis newAxis = state.hasProperty(HorizontalKineticBlock.HORIZONTAL_FACING) ? ((Direction)state.getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getAxis() : (state.hasProperty(DirectionalKineticBlock.FACING) ? ((Direction)state.getValue(DirectionalKineticBlock.FACING)).getAxis() : (state.hasProperty(RotatedPillarKineticBlock.AXIS) ? (Direction.Axis)state.getValue(RotatedPillarKineticBlock.AXIS) : Direction.Axis.Y));
            if (face.getAxis() == newAxis) {
                return PlacementOffset.fail();
            }
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.getLocation(), newAxis);
            for (Direction d : directions) {
                BlockPos newPos = pos.relative(d);
                if (!world.getBlockState(newPos).canBeReplaced()) continue;
                if (!CogWheelBlock.isValidCogwheelPosition(false, (LevelReader)world, newPos, newAxis)) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success().at((Vec3i)newPos).withTransform(s -> (BlockState)s.setValue((Property)CogWheelBlock.AXIS, (Comparable)newAxis));
            }
            return PlacementOffset.fail();
        }
    }

    public static abstract class DiagonalCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> ICogWheel.isSmallCog(s) || ICogWheel.isLargeCog(s);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction.Axis axis = ((IRotate)state.getBlock()).getRotationAxis(state);
            Direction closest = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.getLocation(), axis).getFirst();
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.getLocation(), axis, (Direction d) -> d.getAxis() != closest.getAxis());
            for (Direction dir : directions) {
                BlockPos newPos = pos.relative(dir).relative(closest);
                if (!world.getBlockState(newPos).canBeReplaced() || !CogWheelBlock.isValidCogwheelPosition(ICogWheel.isLargeCog(state), (LevelReader)world, newPos, axis)) continue;
                return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.setValue((Property)BlockStateProperties.AXIS, (Comparable)axis));
            }
            return PlacementOffset.fail();
        }

        protected boolean hitOnShaft(BlockState state, BlockHitResult ray) {
            return AllShapes.SIX_VOXEL_POLE.get(((IRotate)state.getBlock()).getRotationAxis(state)).bounds().inflate(0.001).contains(ray.getLocation().subtract(ray.getLocation().align(Iterate.axisSet)));
        }
    }
}

