/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.simpleRelays.encased;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.content.decoration.encasing.EncasedBlock;
import com.zurrtum.create.content.kinetics.base.AbstractEncasedShaftBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class EncasedShaftBlock
extends AbstractEncasedShaftBlock
implements IBE<KineticBlockEntity>,
SpecialBlockItemRequirement,
EncasedBlock {
    private final Block casing;

    public EncasedShaftBlock(BlockBehaviour.Properties properties, Block casing) {
        super(properties);
        this.casing = casing;
    }

    public static EncasedShaftBlock andesite(BlockBehaviour.Properties properties) {
        return new EncasedShaftBlock(properties, AllBlocks.ANDESITE_CASING);
    }

    public static EncasedShaftBlock brass(BlockBehaviour.Properties properties) {
        return new EncasedShaftBlock(properties, AllBlocks.BRASS_CASING);
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (context.getLevel().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        context.getLevel().levelEvent(2001, context.getClickedPos(), Block.getId((BlockState)state));
        KineticBlockEntity.switchToBlockState(context.getLevel(), context.getClickedPos(), (BlockState)AllBlocks.SHAFT.defaultBlockState().setValue((Property)AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS))));
        return InteractionResult.SUCCESS;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        return this.casing.asItem().getDefaultInstance();
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        return ItemRequirement.of(AllBlocks.SHAFT.defaultBlockState(), be);
    }

    @Override
    public Class<KineticBlockEntity> getBlockEntityClass() {
        return KineticBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ENCASED_SHAFT;
    }

    @Override
    public Block getCasing() {
        return this.casing;
    }

    @Override
    public void handleEncasing(BlockState state, Level level, BlockPos pos, ItemStack heldItem, Player player, InteractionHand hand, BlockHitResult ray) {
        KineticBlockEntity.switchToBlockState(level, pos, (BlockState)this.defaultBlockState().setValue(RotatedPillarKineticBlock.AXIS, (Comparable)((Direction.Axis)state.getValue(RotatedPillarKineticBlock.AXIS))));
    }
}

