/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.steamEngine;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.AbstractShaftBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PoweredShaftBlock
extends AbstractShaftBlock {
    public PoweredShaftBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.EIGHT_VOXEL_POLE.get((Direction.Axis)pState.getValue((Property)AXIS));
    }

    @Override
    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.POWERED_SHAFT;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        IPlacementHelper helper = PlacementHelpers.get(ShaftBlock.placementHelperId);
        if (helper.matchesItem(stack)) {
            return helper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand);
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!PoweredShaftBlock.stillValid(pState, (LevelReader)pLevel, pPos)) {
            pLevel.setBlock(pPos, (BlockState)((BlockState)AllBlocks.SHAFT.defaultBlockState().setValue((Property)ShaftBlock.AXIS, (Comparable)((Direction.Axis)pState.getValue((Property)AXIS)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)WATERLOGGED))), 3);
        }
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        return AllItems.SHAFT.getDefaultInstance();
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return PoweredShaftBlock.stillValid(pState, pLevel, pPos);
    }

    public static boolean stillValid(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        for (Direction d : Iterate.directions) {
            BlockPos enginePos;
            BlockState engineState;
            Block block;
            if (d.getAxis() == pState.getValue((Property)AXIS) || !((block = (engineState = pLevel.getBlockState(enginePos = pPos.relative(d, 2))).getBlock()) instanceof SteamEngineBlock)) continue;
            SteamEngineBlock engine = (SteamEngineBlock)block;
            if (!SteamEngineBlock.getShaftPos(engineState, enginePos).equals((Object)pPos) || !SteamEngineBlock.isShaftValid(engineState, pState)) continue;
            return true;
        }
        return false;
    }

    public static BlockState getEquivalent(BlockState stateForPlacement) {
        return (BlockState)((BlockState)AllBlocks.POWERED_SHAFT.defaultBlockState().setValue((Property)AXIS, (Comparable)((Direction.Axis)stateForPlacement.getValue((Property)ShaftBlock.AXIS)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)stateForPlacement.getValue((Property)WATERLOGGED)));
    }
}

