/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.steamEngine;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.stress.BlockStressValues;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class PoweredShaftBlockEntity
extends GeneratingKineticBlockEntity {
    public BlockPos enginePos;
    public float engineEfficiency;
    public int movementDirection = 1;
    public int initialTicks = 3;
    public Block capacityKey;

    public PoweredShaftBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.POWERED_SHAFT, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.initialTicks > 0) {
            --this.initialTicks;
        }
    }

    public void update(BlockPos sourcePos, int direction, float efficiency) {
        BlockPos key;
        this.enginePos = key = this.worldPosition.subtract((Vec3i)sourcePos);
        float prev = this.engineEfficiency;
        this.engineEfficiency = efficiency;
        int prevDirection = this.movementDirection;
        if (Mth.equal((float)efficiency, (float)prev) && prevDirection == direction) {
            return;
        }
        this.capacityKey = this.level.getBlockState(sourcePos).getBlock();
        this.movementDirection = direction;
        this.updateGeneratedRotation();
    }

    public void remove(BlockPos sourcePos) {
        if (!this.isPoweredBy(sourcePos)) {
            return;
        }
        this.enginePos = null;
        this.engineEfficiency = 0.0f;
        this.movementDirection = 0;
        this.capacityKey = null;
        this.updateGeneratedRotation();
    }

    public boolean canBePoweredBy(BlockPos globalPos) {
        return this.initialTicks == 0 && (this.enginePos == null || this.isPoweredBy(globalPos));
    }

    public boolean isPoweredBy(BlockPos globalPos) {
        BlockPos key = this.worldPosition.subtract((Vec3i)globalPos);
        return key.equals((Object)this.enginePos);
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        view.putInt("Direction", this.movementDirection);
        if (this.initialTicks > 0) {
            view.putInt("Warmup", this.initialTicks);
        }
        if (this.enginePos != null && this.capacityKey != null) {
            view.store("EnginePos", BlockPos.CODEC, (Object)this.enginePos);
            view.putFloat("EnginePower", this.engineEfficiency);
            view.store("EngineType", BuiltInRegistries.BLOCK.byNameCodec(), (Object)this.capacityKey);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.movementDirection = view.getIntOr("Direction", 0);
        this.initialTicks = view.getIntOr("Warmup", 0);
        view.read("EnginePos", BlockPos.CODEC).ifPresentOrElse(pos -> {
            this.enginePos = pos;
            this.engineEfficiency = view.getFloatOr("EnginePower", 0.0f);
            this.capacityKey = view.read("EngineType", BuiltInRegistries.BLOCK.byNameCodec()).orElse(null);
        }, () -> {
            this.enginePos = null;
            this.engineEfficiency = 0.0f;
        });
    }

    @Override
    public float getGeneratedSpeed() {
        return this.getCombinedCapacity() > 0.0f ? (float)(this.movementDirection * 16 * this.getSpeedModifier()) : 0.0f;
    }

    private float getCombinedCapacity() {
        return this.capacityKey == null ? 0.0f : (float)((double)this.engineEfficiency * BlockStressValues.getCapacity(this.capacityKey));
    }

    private int getSpeedModifier() {
        return (int)(1.0 + (this.engineEfficiency >= 1.0f ? 3.0 : Math.min(2.0, Math.floor(this.engineEfficiency * 4.0f))));
    }

    @Override
    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = this.getCombinedCapacity() / (float)this.getSpeedModifier();
        return capacity;
    }

    @Override
    public int getRotationAngleOffset(Direction.Axis axis) {
        int combinedCoords = axis.choose(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
        return super.getRotationAngleOffset(axis) + (combinedCoords % 2 == 0 ? 180 : 0);
    }
}

