/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.depot.storage;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllMountedStorageTypes;
import com.zurrtum.create.api.contraption.storage.SyncedMountedStorage;
import com.zurrtum.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.depot.DepotBlockEntity;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class DepotMountedStorage
extends WrapperMountedItemStorage<Handler>
implements SyncedMountedStorage {
    public static final MapCodec<DepotMountedStorage> CODEC = TransportedItemStack.CODEC.optionalFieldOf("value").xmap(DepotMountedStorage::new, DepotMountedStorage::getHeld);
    private boolean dirty;

    protected DepotMountedStorage(Optional<TransportedItemStack> stack) {
        super(AllMountedStorageTypes.DEPOT);
        this.wrapped = new Handler(stack);
    }

    @Override
    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be instanceof DepotBlockEntity) {
            DepotBlockEntity depot = (DepotBlockEntity)be;
            ((Handler)this.wrapped).getHeld().ifPresentOrElse(depot::setHeldItem, depot::removeHeldItem);
        }
    }

    @Override
    public boolean handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        return false;
    }

    @Override
    public void setChanged() {
        this.dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markClean() {
        this.dirty = false;
    }

    @Override
    public void afterSync(Contraption contraption, BlockPos localPos) {
        BlockEntity be = AllClientHandle.INSTANCE.getBlockEntityClientSide(contraption, localPos);
        if (be instanceof DepotBlockEntity) {
            DepotBlockEntity depot = (DepotBlockEntity)be;
            this.getHeld().ifPresentOrElse(depot::setHeldItem, depot::removeHeldItem);
        }
    }

    public void setHeld(TransportedItemStack stack) {
        ((Handler)this.wrapped).setHeld(Optional.of(stack));
    }

    public void removeHeldItem() {
        ((Handler)this.wrapped).setHeld(Optional.empty());
    }

    public Optional<TransportedItemStack> getHeld() {
        return ((Handler)this.wrapped).getHeld();
    }

    public static DepotMountedStorage fromDepot(DepotBlockEntity depot) {
        TransportedItemStack held = depot.getHeldItem();
        return new DepotMountedStorage(held != null ? Optional.of(held.copy()) : Optional.empty());
    }

    public class Handler
    implements ItemInventory {
        private Optional<TransportedItemStack> held;

        public Handler(Optional<TransportedItemStack> stack) {
            this.held = stack;
        }

        public int getContainerSize() {
            return 1;
        }

        public ItemStack getItem(int slot) {
            if (slot > 1) {
                return ItemStack.EMPTY;
            }
            return this.held.map(Handler::getHeldStack).orElse(ItemStack.EMPTY);
        }

        public void setItem(int slot, ItemStack stack) {
            if (slot > 1) {
                return;
            }
            this.held = stack.isEmpty() ? Optional.empty() : Optional.of(new TransportedItemStack(stack));
        }

        private static ItemStack getHeldStack(TransportedItemStack held) {
            return held.stack;
        }

        public Optional<TransportedItemStack> getHeld() {
            return this.held;
        }

        public void setHeld(Optional<TransportedItemStack> stack) {
            this.held = stack;
        }

        @Override
        public void setChanged() {
            DepotMountedStorage.this.dirty = true;
        }
    }
}

