/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.basin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.basin.BasinInventory;
import com.zurrtum.create.content.processing.basin.BasinOperatingBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.fluids.SidedFluidInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasinBlockEntity
extends SmartBlockEntity {
    public boolean areFluidsMoving = false;
    LerpedFloat ingredientRotationSpeed;
    public LerpedFloat ingredientRotation;
    public SmartFluidTankBehaviour inputTank;
    protected SmartFluidTankBehaviour outputTank;
    private ServerFilteringBehaviour filtering;
    private boolean contentsChanged = true;
    private Couple<SmartFluidTankBehaviour> tanks;
    public BasinInventory itemCapability = new BasinInventory(this);
    public BasinFluidHandler fluidCapability;
    List<Direction> disabledSpoutputs;
    Direction preferredSpoutput = null;
    protected List<ItemStack> spoutputBuffer;
    protected List<FluidStack> spoutputFluidBuffer;
    int recipeBackupCheck = 20;
    public static final int OUTPUT_ANIMATION_TIME = 10;
    public List<IntAttached<ItemStack>> visualizedOutputItems;
    public List<IntAttached<FluidStack>> visualizedOutputFluids;
    @Nullable
    private BlazeBurnerBlock.HeatLevel cachedHeatLevel;

    public BasinBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.BASIN, pos, state);
        this.ingredientRotation = LerpedFloat.angular().startWithValue(0.0);
        this.ingredientRotationSpeed = LerpedFloat.linear().startWithValue(0.0);
        this.tanks = Couple.create(this.inputTank, this.outputTank);
        this.visualizedOutputItems = Collections.synchronizedList(new ArrayList());
        this.visualizedOutputFluids = Collections.synchronizedList(new ArrayList());
        this.disabledSpoutputs = new ArrayList<Direction>();
        this.spoutputBuffer = new ArrayList<ItemStack>();
        this.spoutputFluidBuffer = new ArrayList<FluidStack>();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this));
        this.filtering = new ServerFilteringBehaviour(this).withCallback(newFilter -> {
            this.contentsChanged = true;
        }).forRecipes();
        behaviours.add(this.filtering);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, this, 2, 81000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, this, 2, 81000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add(this.inputTank);
        behaviours.add(this.outputTank);
        this.fluidCapability = new BasinFluidHandler(this.outputTank.getTanks(), this.inputTank.getTanks());
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.itemCapability.read(view);
        this.preferredSpoutput = view.read("PreferredSpoutput", (Codec)Direction.CODEC).orElse(null);
        this.disabledSpoutputs.clear();
        this.spoutputBuffer.clear();
        this.spoutputFluidBuffer.clear();
        view.read("DisabledSpoutput", CreateCodecs.DIRECTION_LIST_CODEC).ifPresent(this.disabledSpoutputs::addAll);
        view.read("Overflow", CreateCodecs.ITEM_LIST_CODEC).ifPresent(this.spoutputBuffer::addAll);
        view.read("FluidOverflow", CreateCodecs.FLUID_LIST_CODEC).ifPresent(this.spoutputFluidBuffer::addAll);
        if (!clientPacket) {
            return;
        }
        view.listOrEmpty("VisualizedItems", ItemStack.OPTIONAL_CODEC).stream().forEach(stack -> this.visualizedOutputItems.add(IntAttached.with(10, stack)));
        view.listOrEmpty("VisualizedFluids", FluidStack.OPTIONAL_CODEC).stream().forEach(stack -> this.visualizedOutputFluids.add(IntAttached.with(10, stack)));
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        this.itemCapability.write(view);
        if (this.preferredSpoutput != null) {
            view.store("PreferredSpoutput", (Codec)Direction.CODEC, (Object)this.preferredSpoutput);
        }
        view.store("DisabledSpoutput", CreateCodecs.DIRECTION_LIST_CODEC, this.disabledSpoutputs);
        view.store("Overflow", CreateCodecs.ITEM_LIST_CODEC, this.spoutputBuffer);
        view.store("FluidOverflow", CreateCodecs.FLUID_LIST_CODEC, this.spoutputFluidBuffer);
        if (!clientPacket) {
            return;
        }
        ValueOutput.TypedOutputList items = view.list("VisualizedItems", ItemStack.OPTIONAL_CODEC);
        this.visualizedOutputItems.stream().map(IntAttached::getValue).forEach(arg_0 -> ((ValueOutput.TypedOutputList)items).add(arg_0));
        ValueOutput.TypedOutputList fluids = view.list("VisualizedFluids", FluidStack.OPTIONAL_CODEC);
        this.visualizedOutputFluids.stream().map(IntAttached::getValue).forEach(arg_0 -> ((ValueOutput.TypedOutputList)fluids).add(arg_0));
        this.visualizedOutputItems.clear();
        this.visualizedOutputFluids.clear();
    }

    @Override
    public void destroy() {
        super.destroy();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)this.itemCapability);
        this.spoutputBuffer.forEach(is -> Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)is));
    }

    @Override
    public void remove() {
        super.remove();
        this.onEmptied();
    }

    public void onEmptied() {
        this.getOperator().ifPresent(be -> {
            be.basinRemoved = true;
        });
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (!this.level.isClientSide()) {
            this.updateSpoutput();
            if (this.recipeBackupCheck-- > 0) {
                return;
            }
            this.recipeBackupCheck = 20;
            if (this.isEmpty()) {
                return;
            }
            this.notifyChangeOfContents();
            return;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.above(2));
        if (!(blockEntity instanceof MechanicalMixerBlockEntity)) {
            this.setAreFluidsMoving(false);
            return;
        }
        MechanicalMixerBlockEntity mixer = (MechanicalMixerBlockEntity)blockEntity;
    }

    public boolean isEmpty() {
        return this.itemCapability.isEmpty() && this.inputTank.isEmpty() && this.outputTank.isEmpty();
    }

    public void onWrenched(Direction face) {
        BlockState blockState = this.getBlockState();
        Direction currentFacing = (Direction)blockState.getValue(BasinBlock.FACING);
        this.disabledSpoutputs.remove(face);
        if (currentFacing == face) {
            if (this.preferredSpoutput == face) {
                this.preferredSpoutput = null;
            }
            this.disabledSpoutputs.add(face);
        } else {
            this.preferredSpoutput = face;
        }
        this.updateSpoutput();
    }

    private void updateSpoutput() {
        BlockState blockState = this.getBlockState();
        Direction currentFacing = (Direction)blockState.getValue(BasinBlock.FACING);
        Direction newFacing = Direction.DOWN;
        for (Direction test : Iterate.horizontalDirections) {
            boolean canOutputTo = BasinBlock.canOutputTo((BlockGetter)this.level, this.worldPosition, test);
            if (!canOutputTo || this.disabledSpoutputs.contains(test)) continue;
            newFacing = test;
        }
        if (this.preferredSpoutput != null && BasinBlock.canOutputTo((BlockGetter)this.level, this.worldPosition, this.preferredSpoutput) && this.preferredSpoutput != Direction.UP) {
            newFacing = this.preferredSpoutput;
        }
        if (newFacing == currentFacing) {
            return;
        }
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)blockState.setValue(BasinBlock.FACING, (Comparable)newFacing));
        if (newFacing.getAxis().isVertical()) {
            return;
        }
        for (int slot = 9; slot < 18; ++slot) {
            ItemStack stack = this.itemCapability.getItem(slot);
            if (stack.isEmpty() || !this.acceptOutputs((List<ItemStack>)ImmutableList.of((Object)stack), Collections.emptyList(), true)) continue;
            this.acceptOutputs((List<ItemStack>)ImmutableList.of((Object)stack), Collections.emptyList(), false);
            this.itemCapability.setItem(slot, ItemStack.EMPTY);
        }
        SidedFluidInventory handler = this.outputTank.getCapability();
        for (int slot = 0; slot < 2; ++slot) {
            FluidStack fs = handler.getStack(slot);
            if (fs.isEmpty()) continue;
            fs = fs.copy();
            if (!this.acceptOutputs(Collections.emptyList(), (List<FluidStack>)ImmutableList.of((Object)fs), true)) continue;
            handler.setStack(slot, FluidStack.EMPTY);
            this.acceptOutputs(Collections.emptyList(), (List<FluidStack>)ImmutableList.of((Object)fs), false);
        }
        this.notifyChangeOfContents();
        this.notifyUpdate();
    }

    @Override
    public void tick() {
        this.cachedHeatLevel = null;
        super.tick();
        if (this.level.isClientSide()) {
            AllClientHandle.INSTANCE.createBasinFluidParticles(this.level, this);
            this.tickVisualizedOutputs();
            this.ingredientRotationSpeed.tickChaser();
            this.ingredientRotation.setValue(this.ingredientRotation.getValue() + this.ingredientRotationSpeed.getValue());
        }
        if (!(this.spoutputBuffer.isEmpty() && this.spoutputFluidBuffer.isEmpty() || this.level.isClientSide())) {
            this.tryClearingSpoutputOverflow();
        }
        if (!this.contentsChanged) {
            return;
        }
        this.contentsChanged = false;
        this.getOperator().ifPresent(be -> be.basinChecker.scheduleUpdate());
        for (Direction offset : Iterate.horizontalDirections) {
            BlockEntity be2;
            BlockPos toUpdate = this.worldPosition.above().relative(offset);
            BlockState stateToUpdate = this.level.getBlockState(toUpdate);
            if (!(stateToUpdate.getBlock() instanceof BasinBlock) || stateToUpdate.getValue(BasinBlock.FACING) != offset.getOpposite() || !((be2 = this.level.getBlockEntity(toUpdate)) instanceof BasinBlockEntity)) continue;
            ((BasinBlockEntity)be2).contentsChanged = true;
        }
    }

    private void tryClearingSpoutputOverflow() {
        Container targetInv;
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof BasinBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.getValue(BasinBlock.FACING);
        BlockEntity be = this.level.getBlockEntity(this.worldPosition.below().relative(direction));
        ServerFilteringBehaviour filter = null;
        InvManipulationBehaviour inserter = null;
        if (be != null) {
            filter = BlockEntityBehaviour.get((BlockGetter)this.level, be.getBlockPos(), ServerFilteringBehaviour.TYPE);
            inserter = BlockEntityBehaviour.get((BlockGetter)this.level, be.getBlockPos(), InvManipulationBehaviour.TYPE);
        }
        if (filter != null && filter.isRecipeFilter()) {
            filter = null;
        }
        Direction opposite = direction.getOpposite();
        Container container = targetInv = be == null ? null : ItemHelper.getInventory(this.level, be.getBlockPos(), null, be, opposite);
        if (targetInv == null && inserter != null) {
            targetInv = (Container)inserter.getInventory();
        }
        FluidInventory targetTank = be == null ? null : FluidHelper.getFluidInventory(this.level, be.getBlockPos(), null, be, opposite);
        boolean update = false;
        Iterator<Object> iterator = this.spoutputBuffer.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = iterator.next();
            if (direction == Direction.DOWN) {
                Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)itemStack);
                iterator.remove();
                update = true;
                continue;
            }
            if (targetInv == null) break;
            if (targetInv.countSpace(itemStack, 1) == 0 || filter != null && !filter.test(itemStack)) continue;
            if (this.visualizedOutputItems.size() < 3) {
                this.visualizedOutputItems.add(IntAttached.withZero(itemStack));
            }
            update = true;
            int count = itemStack.getCount();
            int insert = targetInv.insertExist(itemStack, opposite);
            if (insert == count) {
                iterator.remove();
                continue;
            }
            itemStack.shrink(insert);
        }
        iterator = this.spoutputFluidBuffer.iterator();
        while (iterator.hasNext()) {
            FluidStack fluidStack = (FluidStack)iterator.next();
            if (direction == Direction.DOWN) {
                iterator.remove();
                update = true;
                continue;
            }
            if (targetTank == null) break;
            if (targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? !targetTank.forcePreciseInsert(fluidStack) : !targetTank.preciseInsert(fluidStack, opposite)) continue;
            update = true;
            iterator.remove();
            if (this.visualizedOutputFluids.size() >= 3) continue;
            this.visualizedOutputFluids.add(IntAttached.withZero(fluidStack));
        }
        if (update) {
            this.notifyChangeOfContents();
            this.sendData();
        }
    }

    public float getTotalFluidUnits(float partialTicks) {
        int renderedFluids = 0;
        float totalUnits = 0.0f;
        for (SmartFluidTankBehaviour behaviour : this.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                if (tankSegment.getRenderedFluid().isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                totalUnits += units;
                ++renderedFluids;
            }
        }
        if (renderedFluids == 0) {
            return 0.0f;
        }
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        return totalUnits;
    }

    private Optional<BasinOperatingBlockEntity> getOperator() {
        if (this.level == null) {
            return Optional.empty();
        }
        BlockEntity be = this.level.getBlockEntity(this.worldPosition.above(2));
        if (be instanceof BasinOperatingBlockEntity) {
            return Optional.of((BasinOperatingBlockEntity)be);
        }
        return Optional.empty();
    }

    public ServerFilteringBehaviour getFilter() {
        return this.filtering;
    }

    public void notifyChangeOfContents() {
        this.contentsChanged = true;
    }

    public boolean canContinueProcessing() {
        return this.spoutputBuffer.isEmpty() && this.spoutputFluidBuffer.isEmpty();
    }

    public boolean acceptOutputs(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        this.itemCapability.disableCheck();
        this.outputTank.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, outputFluids, simulate);
        this.itemCapability.enableCheck();
        this.outputTank.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof BasinBlock)) {
            return false;
        }
        Direction direction = (Direction)blockState.getValue(BasinBlock.FACING);
        if (direction != Direction.DOWN) {
            boolean externalTankNotPresent;
            Container targetInv;
            BlockEntity be = this.level.getBlockEntity(this.worldPosition.below().relative(direction));
            InvManipulationBehaviour inserter = be == null ? null : BlockEntityBehaviour.get((BlockGetter)this.level, be.getBlockPos(), InvManipulationBehaviour.TYPE);
            Direction opposite = direction.getOpposite();
            Container container = targetInv = be == null ? null : ItemHelper.getInventory(this.level, be.getBlockPos(), null, be, opposite);
            if (targetInv == null && inserter != null) {
                targetInv = (Container)inserter.getInventory();
            }
            FluidInventory targetTank = be == null ? null : FluidHelper.getFluidInventory(this.level, be.getBlockPos(), null, be, opposite);
            boolean bl = externalTankNotPresent = targetTank == null;
            if (!outputItems.isEmpty() && targetInv == null) {
                return false;
            }
            if (!outputFluids.isEmpty() && externalTankNotPresent) {
                targetTank = this.outputTank.getCapability();
                if (targetTank == null) {
                    return false;
                }
                if (!this.acceptFluidOutputsIntoBasin(outputFluids, simulate, targetTank)) {
                    return false;
                }
            }
            if (simulate) {
                return true;
            }
            for (ItemStack itemStack : outputItems) {
                if (itemStack.isEmpty()) continue;
                this.spoutputBuffer.add(itemStack.copy());
            }
            if (!externalTankNotPresent) {
                for (FluidStack fluidStack : outputFluids) {
                    this.spoutputFluidBuffer.add(fluidStack.copy());
                }
            }
            return true;
        }
        if (!this.acceptItemOutputsIntoBasin(outputItems, simulate, this.itemCapability)) {
            return false;
        }
        if (outputFluids.isEmpty()) {
            return true;
        }
        return this.acceptFluidOutputsIntoBasin(outputFluids, simulate, this.outputTank.getCapability());
    }

    private boolean acceptFluidOutputsIntoBasin(List<FluidStack> outputFluids, boolean simulate, FluidInventory targetTank) {
        if (simulate) {
            return targetTank.countSpace(outputFluids);
        }
        targetTank.insert(outputFluids);
        return true;
    }

    private boolean acceptItemOutputsIntoBasin(List<ItemStack> outputItems, boolean simulate, Container targetInv) {
        if (simulate) {
            return targetInv.countSpace(outputItems, 9, 17);
        }
        targetInv.insert(outputItems, 9, 17);
        return true;
    }

    public void readOnlyItems(ValueInput view) {
        this.itemCapability.read(view);
    }

    public static BlazeBurnerBlock.HeatLevel getHeatLevelOf(BlockState state) {
        if (state.hasProperty(BlazeBurnerBlock.HEAT_LEVEL)) {
            return (BlazeBurnerBlock.HeatLevel)((Object)state.getValue(BlazeBurnerBlock.HEAT_LEVEL));
        }
        return state.is(AllBlockTags.PASSIVE_BOILER_HEATERS) && BlockHelper.isNotUnheated(state) ? BlazeBurnerBlock.HeatLevel.SMOULDERING : BlazeBurnerBlock.HeatLevel.NONE;
    }

    public Couple<SmartFluidTankBehaviour> getTanks() {
        return this.tanks;
    }

    private void tickVisualizedOutputs() {
        this.visualizedOutputFluids.forEach(IntAttached::decrement);
        this.visualizedOutputItems.forEach(IntAttached::decrement);
        this.visualizedOutputFluids.removeIf(IntAttached::isOrBelowZero);
        this.visualizedOutputItems.removeIf(IntAttached::isOrBelowZero);
    }

    public boolean setAreFluidsMoving(boolean areFluidsMoving) {
        this.areFluidsMoving = areFluidsMoving;
        this.ingredientRotationSpeed.chase(areFluidsMoving ? 20.0 : 0.0, 0.1f, LerpedFloat.Chaser.EXP);
        return areFluidsMoving;
    }

    @NotNull
    BlazeBurnerBlock.HeatLevel getHeatLevel() {
        if (this.cachedHeatLevel == null) {
            if (this.level == null) {
                return BlazeBurnerBlock.HeatLevel.NONE;
            }
            this.cachedHeatLevel = BasinBlockEntity.getHeatLevelOf(this.level.getBlockState(this.getBlockPos().below(1)));
        }
        return this.cachedHeatLevel;
    }

    public static class BasinFluidHandler
    implements FluidInventory {
        private static final Optional<Integer> LIMIT = Optional.of(81000);
        private final SmartFluidTankBehaviour.TankSegment[] output;
        private final SmartFluidTankBehaviour.TankSegment[] input;

        public BasinFluidHandler(SmartFluidTankBehaviour.TankSegment[] output, SmartFluidTankBehaviour.TankSegment[] input) {
            this.output = output;
            this.input = input;
        }

        @Override
        public int getMaxAmountPerStack() {
            return 81000;
        }

        @Override
        public FluidStack onExtract(FluidStack stack) {
            return this.removeMaxSize(stack, LIMIT);
        }

        @Override
        public boolean isValid(int slot, FluidStack stack) {
            if (slot < 2) {
                return false;
            }
            int size = this.input.length;
            int current = slot - 2;
            for (int i = 0; i < size; ++i) {
                FluidStack fluid = this.input[i].getFluid();
                if (fluid.isEmpty() || !this.matches(fluid, stack) || i == current) continue;
                return false;
            }
            return true;
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public FluidStack getStack(int slot) {
            if (slot >= 4) {
                return FluidStack.EMPTY;
            }
            return slot < 2 ? this.output[slot].getFluid() : this.input[slot - 2].getFluid();
        }

        @Override
        public void setStack(int slot, FluidStack stack) {
            if (slot >= 4) {
                return;
            }
            SmartFluidTankBehaviour.TankSegment tank = slot < 2 ? this.output[slot] : this.input[slot - 2];
            tank.setFluid(stack);
        }

        @Override
        public void markDirty() {
            for (SmartFluidTankBehaviour.TankSegment tank : this.input) {
                tank.markDirty();
            }
            for (SmartFluidTankBehaviour.TankSegment tank : this.output) {
                tank.markDirty();
            }
        }
    }
}

