/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.basin;

import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BasinMovementBehaviour
extends MovementBehaviour {
    private static final Vec3 UP = Vec3.atLowerCornerOf((Vec3i)Direction.UP.getUnitVec3i());

    @Override
    public void tick(MovementContext context) {
        Vec3 facingVec;
        if (context.temporaryData == null && Direction.getApproximateNearest((Vec3)(facingVec = (Vec3)context.rotation.apply(UP))) == Direction.DOWN) {
            this.dump(context, facingVec);
        }
    }

    @Nullable
    public static List<ItemStack> readInventory(MovementContext context) {
        return context.blockEntityData.getCompound("Inventory").map(nbt -> {
            RegistryOps ops = context.world.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            ArrayList result = new ArrayList();
            nbt.getList("Input").ifPresent(list -> list.forEach(item -> ItemStack.CODEC.parse((DynamicOps)ops, item).ifSuccess(result::add)));
            nbt.getList("Output").ifPresent(list -> list.forEach(item -> ItemStack.CODEC.parse((DynamicOps)ops, item).ifSuccess(result::add)));
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }).orElse(null);
    }

    private void dump(MovementContext context, Vec3 facingVec) {
        BlockEntity blockEntity;
        List<ItemStack> inventory = BasinMovementBehaviour.readInventory(context);
        if (inventory == null) {
            return;
        }
        Vec3 velocity = facingVec.scale(0.5);
        Level world = context.world;
        for (ItemStack stack : inventory) {
            ItemEntity item = new ItemEntity(world, context.position.x, context.position.y, context.position.z, stack);
            item.setDeltaMovement(velocity);
            world.addFreshEntity((Entity)item);
        }
        context.blockEntityData.remove("Inventory");
        if (context.contraption.entity.level().isClientSide() && (blockEntity = AllClientHandle.INSTANCE.getBlockEntityClientSide(context.contraption, context.localPos)) instanceof BasinBlockEntity) {
            BasinBlockEntity basin = (BasinBlockEntity)blockEntity;
            basin.itemCapability.clearContent();
        }
        context.temporaryData = Boolean.TRUE;
    }
}

