/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.diodes;

import com.mojang.serialization.Codec;
import com.zurrtum.create.content.equipment.clipboard.ClipboardCloneable;
import com.zurrtum.create.content.redstone.diodes.BrassDiodeBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerBrassDiodeScrollValueBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class BrassDiodeBlockEntity
extends SmartBlockEntity
implements ClipboardCloneable {
    public int state;
    ServerScrollValueBehaviour maxState;

    public BrassDiodeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.maxState = new ServerBrassDiodeScrollValueBehaviour(this).between(2, 72000);
        this.maxState.withCallback(this::onMaxDelayChanged);
        this.maxState.setValue(this.defaultValue());
        behaviours.add(this.maxState);
    }

    protected int defaultValue() {
        return 2;
    }

    public float getProgress() {
        int max = Math.max(2, this.maxState.getValue());
        return (float)Mth.clamp((int)this.state, (int)0, (int)max) / (float)max;
    }

    public boolean isIdle() {
        return this.state == 0;
    }

    @Override
    public void tick() {
        super.tick();
        boolean powered = (Boolean)this.getBlockState().getValue((Property)DiodeBlock.POWERED);
        boolean powering = (Boolean)this.getBlockState().getValue((Property)BrassDiodeBlock.POWERING);
        boolean atMax = this.state >= this.maxState.getValue();
        boolean atMin = this.state <= 0;
        this.updateState(powered, powering, atMax, atMin);
    }

    protected abstract void updateState(boolean var1, boolean var2, boolean var3, boolean var4);

    private void onMaxDelayChanged(int newMax) {
        this.state = Mth.clamp((int)this.state, (int)0, (int)newMax);
        this.sendData();
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.state = view.getIntOr("State", 0);
        super.read(view, clientPacket);
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.putInt("State", this.state);
        super.write(view, clientPacket);
    }

    @Override
    public String getClipboardKey() {
        return "Block";
    }

    @Override
    public boolean readFromClipboard(ValueInput view, Player player, Direction side, boolean simulate) {
        Optional inverted = view.read("Inverted", (Codec)Codec.BOOL);
        if (inverted.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        BlockState blockState = this.getBlockState();
        if (blockState.getValue((Property)BrassDiodeBlock.INVERTED) != inverted.get()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)blockState.cycle((Property)BrassDiodeBlock.INVERTED));
        }
        return true;
    }

    @Override
    public boolean writeToClipboard(ValueOutput view, Direction side) {
        view.store("Inverted", (Codec)Codec.BOOL, (Object)((Boolean)this.getBlockState().getValueOrElse((Property)BrassDiodeBlock.INVERTED, (Comparable)Boolean.valueOf(false))));
        return true;
    }
}

