/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.source.RedstonePowerDisplaySource;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayLinkBlock
extends WrenchableDirectionalBlock
implements IBE<DisplayLinkBlockEntity>,
NeighborUpdateListeningBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final MapCodec<DisplayLinkBlock> CODEC = DisplayLinkBlock.simpleCodec(DisplayLinkBlock::new);

    public DisplayLinkBlock(BlockBehaviour.Properties p_i48415_1_) {
        super(p_i48415_1_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placed = super.getStateForPlacement(context);
        placed = (BlockState)placed.setValue((Property)FACING, (Comparable)context.getClickedFace());
        return (BlockState)placed.setValue((Property)POWERED, (Comparable)Boolean.valueOf(this.shouldBePowered(placed, context.getLevel(), context.getClickedPos())));
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public static void notifyGatherers(LevelAccessor level, BlockPos pos) {
        DisplayLinkBlock.forEachAttachedGatherer(level, pos, DisplayLinkBlockEntity::tickSource);
    }

    public static <T extends DisplaySource> void sendToGatherers(LevelAccessor level, BlockPos pos, BiConsumer<DisplayLinkBlockEntity, T> callback, Class<T> type) {
        DisplayLinkBlock.forEachAttachedGatherer(level, pos, dgte -> {
            if (type.isInstance(dgte.activeSource)) {
                callback.accept((DisplayLinkBlockEntity)dgte, (Object)dgte.activeSource);
            }
        });
    }

    private static void forEachAttachedGatherer(LevelAccessor level, BlockPos pos, Consumer<DisplayLinkBlockEntity> callback) {
        for (Direction d : Iterate.directions) {
            BlockEntity blockEntity;
            BlockPos offsetPos = pos.relative(d);
            BlockState blockState = level.getBlockState(offsetPos);
            if (!blockState.is((Block)AllBlocks.DISPLAY_LINK) || !((blockEntity = level.getBlockEntity(offsetPos)) instanceof DisplayLinkBlockEntity)) continue;
            DisplayLinkBlockEntity dlbe = (DisplayLinkBlockEntity)blockEntity;
            if (dlbe.activeSource == null || dlbe.getDirection() != d.getOpposite()) continue;
            callback.accept(dlbe);
        }
    }

    @Override
    public void neighborUpdate(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.isClientSide()) {
            return;
        }
        if (fromPos.equals((Object)pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()))) {
            DisplayLinkBlock.sendToGatherers((LevelAccessor)worldIn, fromPos, (dlte, p) -> dlte.tickSource(), RedstonePowerDisplaySource.class);
        }
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, @Nullable Orientation wireOrientation, boolean isMoving) {
        if (worldIn.isClientSide()) {
            return;
        }
        boolean powered = this.shouldBePowered(state, worldIn, pos);
        boolean previouslyPowered = (Boolean)state.getValue((Property)POWERED);
        if (previouslyPowered != powered) {
            worldIn.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
            if (!powered) {
                this.withBlockEntityDo((BlockGetter)worldIn, pos, DisplayLinkBlockEntity::onNoLongerPowered);
            }
        }
    }

    private boolean shouldBePowered(BlockState state, Level worldIn, BlockPos pos) {
        boolean powered = false;
        for (Direction d : Iterate.directions) {
            if (d.getOpposite() == state.getValue((Property)FACING) || worldIn.getSignal(pos.relative(d), d) == 0) continue;
            powered = true;
            break;
        }
        return powered;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{POWERED}));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide()) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> AllClientHandle.INSTANCE.openDisplayLinkScreen((DisplayLinkBlockEntity)be, player));
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.DATA_GATHERER.get((Direction)pState.getValue((Property)FACING));
    }

    @Override
    public Class<DisplayLinkBlockEntity> getBlockEntityClass() {
        return DisplayLinkBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends DisplayLinkBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.DISPLAY_LINK;
    }

    @Override
    @NotNull
    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }
}

