/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.source.ValueListDisplaySource;
import com.zurrtum.create.content.redstone.smartObserver.SmartObserverBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.item.CountedItemStackList;
import java.util.stream.Stream;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemListDisplaySource
extends ValueListDisplaySource {
    @Override
    protected Stream<IntAttached<MutableComponent>> provideEntries(DisplayLinkContext context, int maxRows) {
        BlockEntity sourceBE = context.getSourceBlockEntity();
        if (!(sourceBE instanceof SmartObserverBlockEntity)) {
            return Stream.empty();
        }
        SmartObserverBlockEntity cobe = (SmartObserverBlockEntity)sourceBE;
        InvManipulationBehaviour invManipulationBehaviour = cobe.getBehaviour(InvManipulationBehaviour.TYPE);
        Container handler = (Container)invManipulationBehaviour.getInventory();
        if (handler == null) {
            return Stream.empty();
        }
        ServerFilteringBehaviour filteringBehaviour = cobe.getBehaviour(ServerFilteringBehaviour.TYPE);
        return new CountedItemStackList(handler, filteringBehaviour).getTopNames(maxRows);
    }

    @Override
    protected String getTranslationKey() {
        return "list_items";
    }

    @Override
    protected boolean valueFirst() {
        return true;
    }
}

