/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.link.controller;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.content.redstone.link.controller.LecternControllerBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class LecternControllerBlockEntity
extends SmartBlockEntity {
    private ItemContainerContents controllerData = ItemContainerContents.EMPTY;
    public UUID user;
    public UUID prevUser;
    private boolean deactivatedThisTick;

    public LecternControllerBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.LECTERN_CONTROLLER, pos, state);
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        this.dropController(state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.store("ControllerData", ItemContainerContents.CODEC, (Object)this.controllerData);
        if (this.user != null) {
            view.store("User", UUIDUtil.CODEC, (Object)this.user);
        }
    }

    @Override
    public void writeSafe(ValueOutput view) {
        super.writeSafe(view);
        view.store("ControllerData", ItemContainerContents.CODEC, (Object)this.controllerData);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.controllerData = view.read("ControllerData", ItemContainerContents.CODEC).orElse(ItemContainerContents.EMPTY);
        this.user = view.read("User", UUIDUtil.CODEC).orElse(null);
    }

    public ItemStack getController() {
        return this.createLinkedController();
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public boolean isUsedBy(Player player) {
        return this.hasUser() && this.user.equals(player.getUUID());
    }

    public void tryStartUsing(Player player) {
        if (!this.deactivatedThisTick && !this.hasUser() && !LecternControllerBlockEntity.playerIsUsingLectern(player) && LecternControllerBlockEntity.playerInRange(player, this.level, this.worldPosition)) {
            this.startUsing(player);
        }
    }

    public void tryStopUsing(Player player) {
        if (this.isUsedBy(player)) {
            this.stopUsing(player);
        }
    }

    private void startUsing(Player player) {
        this.user = player.getUUID();
        AllSynchedDatas.IS_USING_LECTERN_CONTROLLER.set((Entity)player, true);
        this.sendData();
    }

    private void stopUsing(Player player) {
        this.user = null;
        if (player != null) {
            AllSynchedDatas.IS_USING_LECTERN_CONTROLLER.set((Entity)player, false);
        }
        this.deactivatedThisTick = true;
        this.sendData();
    }

    public static boolean playerIsUsingLectern(Player player) {
        return AllSynchedDatas.IS_USING_LECTERN_CONTROLLER.get((Entity)player);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            AllClientHandle.INSTANCE.tryToggleActive(this);
            this.prevUser = this.user;
        }
        if (!this.level.isClientSide()) {
            this.deactivatedThisTick = false;
            if (!(this.level instanceof ServerLevel)) {
                return;
            }
            if (this.user == null) {
                return;
            }
            Entity entity = this.level.getEntity(this.user);
            if (!(entity instanceof Player)) {
                this.stopUsing(null);
                return;
            }
            Player player = (Player)entity;
            if (!LecternControllerBlockEntity.playerInRange(player, this.level, this.worldPosition) || !LecternControllerBlockEntity.playerIsUsingLectern(player)) {
                this.stopUsing(player);
            }
        }
    }

    public void setController(ItemStack newController) {
        if (newController != null) {
            this.controllerData = (ItemContainerContents)newController.getOrDefault(AllDataComponents.LINKED_CONTROLLER_ITEMS, (Object)ItemContainerContents.EMPTY);
            AllSoundEvents.CONTROLLER_PUT.playOnServer(this.level, (Vec3i)this.worldPosition);
        }
    }

    public void swapControllers(ItemStack stack, Player player, InteractionHand hand, BlockState state) {
        ItemStack newController = stack.copy();
        stack.setCount(0);
        if (player.getItemInHand(hand).isEmpty()) {
            player.setItemInHand(hand, this.createLinkedController());
        } else {
            this.dropController(state);
        }
        this.setController(newController);
    }

    public void dropController(BlockState state) {
        Entity entity = this.level.getEntity(this.user);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.stopUsing(player);
        }
        Direction dir = (Direction)state.getValue((Property)LecternControllerBlock.FACING);
        double x = (double)this.worldPosition.getX() + 0.5 + 0.25 * (double)dir.getStepX();
        double y = this.worldPosition.getY() + 1;
        double z = (double)this.worldPosition.getZ() + 0.5 + 0.25 * (double)dir.getStepZ();
        ItemEntity itementity = new ItemEntity(this.level, x, y, z, this.createLinkedController());
        itementity.setDefaultPickUpDelay();
        this.level.addFreshEntity((Entity)itementity);
        this.controllerData = ItemContainerContents.EMPTY;
    }

    public static boolean playerInRange(Player player, Level world, BlockPos pos) {
        double reach = 0.4 * player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        return player.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) < reach * reach;
    }

    private ItemStack createLinkedController() {
        ItemStack stack = AllItems.LINKED_CONTROLLER.getDefaultInstance();
        stack.set(AllDataComponents.LINKED_CONTROLLER_ITEMS, (Object)this.controllerData);
        return stack;
    }
}

