/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.graph;

import com.google.common.base.Objects;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackEdgeIntersection;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.signal.SignalBoundary;
import com.zurrtum.create.content.trains.signal.SignalEdgeGroup;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class EdgeData {
    public static final UUID passiveGroup = UUID.fromString("00000000-0000-0000-0000-000000000000");
    private UUID singleSignalGroup;
    private List<TrackEdgePoint> points;
    private List<TrackEdgeIntersection> intersections;
    private TrackEdge edge;

    public EdgeData(TrackEdge edge) {
        this.edge = edge;
        this.points = new ArrayList<TrackEdgePoint>();
        this.intersections = new ArrayList<TrackEdgeIntersection>();
        this.singleSignalGroup = passiveGroup;
    }

    public boolean hasSignalBoundaries() {
        return this.singleSignalGroup == null;
    }

    public UUID getSingleSignalGroup() {
        return this.singleSignalGroup;
    }

    public void setSingleSignalGroup(@Nullable MinecraftServer server, @Nullable TrackGraph graph, UUID singleSignalGroup) {
        if (graph != null && !Objects.equal((Object)singleSignalGroup, (Object)this.singleSignalGroup)) {
            this.refreshIntersectingSignalGroups(server, graph);
        }
        this.singleSignalGroup = singleSignalGroup;
    }

    public void refreshIntersectingSignalGroups(MinecraftServer server, TrackGraph graph) {
        Map<UUID, SignalEdgeGroup> groups = Create.RAILWAYS.signalEdgeGroups;
        for (TrackEdgeIntersection intersection : this.intersections) {
            SignalEdgeGroup group;
            if (intersection.groupId == null || (group = groups.get(intersection.groupId)) == null) continue;
            group.removeIntersection(server, intersection.id);
        }
        if (this.hasIntersections()) {
            graph.deferIntersectionUpdate(this.edge);
        }
    }

    public boolean hasPoints() {
        return !this.points.isEmpty();
    }

    public boolean hasIntersections() {
        return !this.intersections.isEmpty();
    }

    public List<TrackEdgeIntersection> getIntersections() {
        return this.intersections;
    }

    public void addIntersection(TrackGraph graph, UUID id, double position, TrackNode target1, TrackNode target2, double targetPosition) {
        TrackNodeLocation loc1 = target1.getLocation();
        TrackNodeLocation loc2 = target2.getLocation();
        for (TrackEdgeIntersection existing : this.intersections) {
            if (!existing.isNear(position) || !existing.targets(loc1, loc2)) continue;
            return;
        }
        TrackEdgeIntersection intersection = new TrackEdgeIntersection();
        intersection.id = id;
        intersection.location = position;
        intersection.target = Couple.create(loc1, loc2);
        intersection.targetLocation = targetPosition;
        this.intersections.add(intersection);
        graph.deferIntersectionUpdate(this.edge);
    }

    public void removeIntersection(MinecraftServer server, TrackGraph graph, UUID id) {
        this.refreshIntersectingSignalGroups(server, graph);
        Iterator<TrackEdgeIntersection> iterator = this.intersections.iterator();
        while (iterator.hasNext()) {
            TrackEdgeIntersection existing = iterator.next();
            if (!existing.id.equals(id)) continue;
            iterator.remove();
        }
    }

    public UUID getGroupAtPosition(TrackGraph graph, double position) {
        if (!this.hasSignalBoundaries()) {
            return this.getEffectiveEdgeGroupId(graph);
        }
        SignalBoundary firstSignal = this.next(EdgePointType.SIGNAL, 0.0);
        if (firstSignal == null) {
            return null;
        }
        UUID currentGroup = firstSignal.getGroup(this.edge.node1);
        for (TrackEdgePoint trackEdgePoint : this.getPoints()) {
            if (!(trackEdgePoint instanceof SignalBoundary)) continue;
            SignalBoundary sb = (SignalBoundary)trackEdgePoint;
            if (sb.getLocationOn(this.edge) >= position) {
                return currentGroup;
            }
            currentGroup = sb.getGroup(this.edge.node2);
        }
        return currentGroup;
    }

    public List<TrackEdgePoint> getPoints() {
        return this.points;
    }

    public UUID getEffectiveEdgeGroupId(TrackGraph graph) {
        return this.singleSignalGroup == null ? null : (this.singleSignalGroup.equals(passiveGroup) ? graph.id : this.singleSignalGroup);
    }

    public void removePoint(MinecraftServer server, TrackGraph graph, TrackEdgePoint point) {
        this.points.remove(point);
        if (point.getType() == EdgePointType.SIGNAL) {
            boolean noSignalsRemaining = this.next(point.getType(), 0.0) == null;
            this.setSingleSignalGroup(server, graph, noSignalsRemaining ? passiveGroup : null);
        }
    }

    public <T extends TrackEdgePoint> void addPoint(MinecraftServer server, TrackGraph graph, TrackEdgePoint point) {
        int i;
        if (point.getType() == EdgePointType.SIGNAL) {
            this.setSingleSignalGroup(server, graph, null);
        }
        double locationOn = point.getLocationOn(this.edge);
        for (i = 0; i < this.points.size() && !(this.points.get(i).getLocationOn(this.edge) > locationOn); ++i) {
        }
        this.points.add(i, point);
    }

    @Nullable
    public <T extends TrackEdgePoint> T next(EdgePointType<T> type, double minPosition) {
        for (TrackEdgePoint point : this.points) {
            if (point.getType() != type || !(point.getLocationOn(this.edge) > minPosition)) continue;
            return (T)point;
        }
        return null;
    }

    @Nullable
    public TrackEdgePoint next(double minPosition) {
        for (TrackEdgePoint point : this.points) {
            if (!(point.getLocationOn(this.edge) > minPosition)) continue;
            return point;
        }
        return null;
    }

    @Nullable
    public <T extends TrackEdgePoint> T get(EdgePointType<T> type, double exactPosition) {
        T next = this.next(type, exactPosition - 0.5);
        if (next != null && Mth.equal((double)((TrackEdgePoint)next).getLocationOn(this.edge), (double)exactPosition)) {
            return next;
        }
        return null;
    }

    public void write(ValueOutput view, DimensionPalette dimensions) {
        ValueOutput.ValueOutputList list;
        if (this.singleSignalGroup == passiveGroup) {
            view.putBoolean("PassiveGroup", true);
        } else if (this.singleSignalGroup != null) {
            view.store("SignalGroup", UUIDUtil.CODEC, (Object)this.singleSignalGroup);
        }
        if (this.hasPoints()) {
            list = view.childrenList("Points");
            for (TrackEdgePoint point : this.points) {
                ValueOutput item = list.addChild();
                item.store("Id", UUIDUtil.CODEC, (Object)point.id);
                item.store("Type", EdgePointType.CODEC, point.getType());
            }
        }
        if (this.hasIntersections()) {
            list = view.childrenList("Intersections");
            for (TrackEdgeIntersection intersection : this.intersections) {
                intersection.write(list.addChild(), dimensions);
            }
        }
    }

    public static <T> DataResult<T> encode(EdgeData input, DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        ListBuilder list;
        RecordBuilder builder = ops.mapBuilder();
        if (input.singleSignalGroup == passiveGroup) {
            builder.add("PassiveGroup", ops.createBoolean(true));
        } else if (input.singleSignalGroup != null) {
            builder.add("SignalGroup", (Object)input.singleSignalGroup, (Encoder)UUIDUtil.CODEC);
        }
        if (input.hasPoints()) {
            list = ops.listBuilder();
            for (TrackEdgePoint point : input.points) {
                RecordBuilder item = ops.mapBuilder();
                item.add("Id", (Object)point.id, (Encoder)UUIDUtil.CODEC);
                item.add("Type", point.getType(), EdgePointType.CODEC);
                list.add(item.build(empty));
            }
            builder.add("Points", list.build(empty));
        }
        if (input.hasIntersections()) {
            list = ops.listBuilder();
            for (TrackEdgeIntersection intersection : input.intersections) {
                list.add(TrackEdgeIntersection.encode(intersection, ops, empty, dimensions));
            }
            builder.add("Intersections", list.build(empty));
        }
        return builder.build(empty);
    }

    public static EdgeData read(ValueInput view, TrackEdge edge, TrackGraph graph, DimensionPalette dimensions) {
        EdgeData data = new EdgeData(edge);
        view.read("SignalGroup", UUIDUtil.CODEC).ifPresentOrElse(id -> {
            data.singleSignalGroup = id;
        }, () -> {
            if (!view.getBooleanOr("PassiveGroup", false)) {
                data.singleSignalGroup = null;
            }
        });
        view.childrenList("Points").ifPresent(list -> list.forEach(item -> item.read("Type", EdgePointType.CODEC).flatMap(type -> item.read("Id", UUIDUtil.CODEC).map(id -> graph.getPoint(type, (UUID)id))).ifPresent(data.points::add)));
        view.childrenList("Intersections").ifPresent(list -> list.forEach(item -> data.intersections.add(TrackEdgeIntersection.read(item, dimensions))));
        return data;
    }

    public static <T> EdgeData decode(DynamicOps<T> ops, T input, TrackEdge edge, TrackGraph graph, DimensionPalette dimensions) {
        EdgeData data = new EdgeData(edge);
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        UUIDUtil.CODEC.decode(ops, map.get("SignalGroup")).result().map(Pair::getFirst).ifPresentOrElse(id -> {
            data.singleSignalGroup = id;
        }, () -> {
            if (!Optional.ofNullable(map.get("PassiveGroup")).flatMap(value -> ops.getBooleanValue(value).result()).orElse(false).booleanValue()) {
                data.singleSignalGroup = null;
            }
        });
        ops.getList(map.get("Points")).ifSuccess(list -> list.accept(item -> {
            MapLike point = (MapLike)ops.getMap(item).getOrThrow();
            EdgePointType.CODEC.decode(ops, point.get("Type")).result().map(Pair::getFirst).flatMap(type -> UUIDUtil.CODEC.decode(ops, point.get("Id")).result().map(Pair::getFirst).map(id -> graph.getPoint(type, (UUID)id))).ifPresent(data.points::add);
        }));
        ops.getList(map.get("Intersections")).ifSuccess(list -> list.accept(item -> data.intersections.add(TrackEdgeIntersection.decode(ops, item, dimensions))));
        return data;
    }
}

