/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.condition.CargoThresholdCondition;
import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ItemThresholdCondition
extends CargoThresholdCondition {
    public FilterItemStack stack = FilterItemStack.empty();

    public ItemThresholdCondition(Identifier id) {
        super(id);
    }

    @Override
    protected boolean test(Level level, Train train, CompoundTag context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        int target = this.getThreshold();
        boolean stacks = this.inStacks();
        int foundItems = 0;
        for (Carriage carriage : train.carriages) {
            Iterator iterator = carriage.storage.getAllItems().iterator();
            while (iterator.hasNext()) {
                ItemStack stackInSlot = (ItemStack)iterator.next();
                if (!this.stack.test(level, stackInSlot)) continue;
                if (stacks) {
                    foundItems += stackInSlot.getCount() == stackInSlot.getMaxStackSize() ? 1 : 0;
                    continue;
                }
                foundItems += stackInSlot.getCount();
            }
        }
        this.requestStatusToUpdate(foundItems, context);
        return operator.test(foundItems, target);
    }

    @Override
    protected void writeAdditional(ValueOutput view) {
        super.writeAdditional(view);
        view.store("Item", FilterItemStack.CODEC, (Object)this.stack);
    }

    @Override
    protected void readAdditional(ValueInput view) {
        super.readAdditional(view);
        view.read("Item", FilterItemStack.CODEC).ifPresent(stack -> {
            this.stack = stack;
        });
    }

    @Override
    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        return super.tickCompletion(level, train, context);
    }

    public boolean inStacks() {
        return this.intData("Measure") == 1;
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, Train train, CompoundTag tag) {
        int lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1) {
            return Component.empty();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return Component.translatable((String)"create.schedule.condition.threshold.status", (Object[])new Object[]{lastDisplaySnapshot, Math.max(0, this.getThreshold() + offset), Component.translatable((String)("create.schedule.condition.threshold." + (this.inStacks() ? "stacks" : "items")))});
    }
}

