/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.item;

import com.zurrtum.create.AllTransfer;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class InventoryCache
implements Supplier<Container> {
    private final BiPredicate<BlockEntity, Direction> filter;
    public final ServerLevel world;
    public final Direction direction;
    public final BlockPos pos;
    public boolean cached;
    public Container inventory;
    public Supplier<Container> getter = this::refresh;

    public InventoryCache(ServerLevel world, BlockPos pos, Direction direction, BiPredicate<BlockEntity, Direction> filter) {
        this.world = world;
        this.direction = direction;
        this.pos = pos;
        this.filter = filter;
    }

    @Override
    public Container get() {
        if (this.cached) {
            return this.inventory;
        }
        this.inventory = this.getter.get();
        return this.inventory;
    }

    public void invalidate() {
        this.cached = false;
        this.getter = this::refresh;
    }

    private Container refresh() {
        this.cached = true;
        BlockState state = this.world.getBlockState(this.pos);
        Block block = state.getBlock();
        BlockEntity blockEntity = this.world.getBlockEntity(this.pos);
        if (blockEntity != null && this.filter != null && !this.filter.test(blockEntity, this.direction)) {
            return null;
        }
        if (block instanceof ItemInventoryProvider) {
            ItemInventoryProvider provider = (ItemInventoryProvider)block;
            return provider.getInventory(state, (LevelAccessor)this.world, this.pos, blockEntity, this.direction);
        }
        if (block instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder provider = (WorldlyContainerHolder)block;
            return provider.getContainer(state, (LevelAccessor)this.world, this.pos);
        }
        if (blockEntity instanceof Container) {
            Container entityInventory = (Container)blockEntity;
            return entityInventory;
        }
        this.getter = AllTransfer.getCacheInventory(this.world, this.pos, this.direction, this.filter);
        if (this.getter == null) {
            return null;
        }
        this.cached = false;
        return this.getter.get();
    }
}

