/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record AutoRequestData(PackageOrderWithCrafts encodedRequest, String encodedTargetAddress, BlockPos targetOffset, String targetDim, boolean isValid) {
    public static final Codec<AutoRequestData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PackageOrderWithCrafts.CODEC.fieldOf("encoded_request").forGetter(AutoRequestData::encodedRequest), (App)Codec.STRING.fieldOf("encoded_target_address").forGetter(AutoRequestData::encodedTargetAddress), (App)BlockPos.CODEC.fieldOf("target_offset").forGetter(AutoRequestData::targetOffset), (App)Codec.STRING.fieldOf("target_dim").forGetter(AutoRequestData::targetDim), (App)Codec.BOOL.fieldOf("is_valid").forGetter(AutoRequestData::isValid)).apply((Applicative)instance, AutoRequestData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AutoRequestData> STREAM_CODEC = StreamCodec.composite(PackageOrderWithCrafts.STREAM_CODEC, AutoRequestData::encodedRequest, (StreamCodec)ByteBufCodecs.STRING_UTF8, AutoRequestData::encodedTargetAddress, (StreamCodec)BlockPos.STREAM_CODEC, AutoRequestData::targetOffset, (StreamCodec)ByteBufCodecs.STRING_UTF8, AutoRequestData::targetDim, (StreamCodec)ByteBufCodecs.BOOL, AutoRequestData::isValid, AutoRequestData::new);

    public AutoRequestData() {
        this(PackageOrderWithCrafts.empty(), "", BlockPos.ZERO, "null", false);
    }

    public void writeToItem(BlockPos position, ItemStack itemStack) {
        Mutable mutable = new Mutable(this);
        mutable.targetOffset = position.offset((Vec3i)this.targetOffset);
        itemStack.set(AllDataComponents.AUTO_REQUEST_DATA, (Object)mutable.toImmutable());
    }

    public static AutoRequestData readFromItem(Level level, Player player, BlockPos position, ItemStack itemStack) {
        AutoRequestData requestData = (AutoRequestData)itemStack.get(AllDataComponents.AUTO_REQUEST_DATA);
        if (requestData == null) {
            return null;
        }
        Mutable mutable = new Mutable(requestData);
        mutable.targetOffset = mutable.targetOffset.subtract((Vec3i)position);
        boolean bl = mutable.isValid = mutable.targetOffset.closerThan((Vec3i)BlockPos.ZERO, 128.0) && requestData.targetDim.equals(level.dimension().identifier().toString());
        if (player != null) {
            MutableComponent message = mutable.isValid ? Component.translatable((String)"create.redstone_requester.keeper_connected").withStyle(ChatFormatting.WHITE) : Component.translatable((String)"create.redstone_requester.keeper_too_far_away").withStyle(ChatFormatting.RED);
            player.displayClientMessage((Component)message, true);
        }
        return mutable.toImmutable();
    }

    public static class Mutable {
        public PackageOrderWithCrafts encodedRequest = PackageOrderWithCrafts.empty();
        public String encodedTargetAddress = "";
        public BlockPos targetOffset = BlockPos.ZERO;
        public String targetDim = "null";
        public boolean isValid = false;

        public Mutable() {
        }

        public Mutable(AutoRequestData data) {
            this.encodedRequest = data.encodedRequest;
            this.encodedTargetAddress = data.encodedTargetAddress;
            this.targetOffset = data.targetOffset;
            this.targetDim = data.targetDim;
            this.isValid = data.isValid;
        }

        public AutoRequestData toImmutable() {
            return new AutoRequestData(this.encodedRequest, this.encodedTargetAddress, this.targetOffset, this.targetDim, this.isValid);
        }
    }
}

