/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.packet.s2c;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.infrastructure.packet.s2c.S2CPacket;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketType;
import org.apache.logging.log4j.util.TriConsumer;

public record TrackGraphRollCallPacket(List<Entry> entries) implements S2CPacket
{
    public static final StreamCodec<ByteBuf, TrackGraphRollCallPacket> CODEC = CatnipStreamCodecBuilders.list(Entry.STREAM_CODEC).map(TrackGraphRollCallPacket::new, TrackGraphRollCallPacket::entries);

    public static TrackGraphRollCallPacket ofServer() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (TrackGraph graph : Create.RAILWAYS.trackNetworks.values()) {
            entries.add(new Entry(graph.netId, graph.getChecksum()));
        }
        return new TrackGraphRollCallPacket(entries);
    }

    public <T> TriConsumer<AllClientHandle<T>, T, TrackGraphRollCallPacket> callback() {
        return AllClientHandle::onTrackGraphRollCall;
    }

    public PacketType<TrackGraphRollCallPacket> type() {
        return AllPackets.TRACK_GRAPH_ROLL_CALL;
    }

    public record Entry(int netId, int checksum) {
        public static final StreamCodec<ByteBuf, Entry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Entry::netId, (StreamCodec)ByteBufCodecs.INT, Entry::checksum, Entry::new);
    }
}

