/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.mixin;

import com.google.common.collect.Maps;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.serialization.Codec;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.station.StationMapData;
import com.zurrtum.create.content.trains.station.StationMarker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MapItemSavedData.class})
public abstract class MapItemSavedDataMixin
implements StationMapData {
    @Shadow
    @Final
    public int centerX;
    @Shadow
    @Final
    public int centerZ;
    @Shadow
    @Final
    public byte scale;
    @Shadow
    @Final
    private Map<String, MapDecoration> decorations;
    @Shadow
    private int trackedDecorationCount;
    @Unique
    private final Map<String, StationMarker> create$stationMarkers = Maps.newHashMap();

    @ModifyExpressionValue(method={"type(Lnet/minecraft/world/level/saveddata/maps/MapId;)Lnet/minecraft/world/level/saveddata/SavedDataType;"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/saveddata/maps/MapItemSavedData;CODEC:Lcom/mojang/serialization/Codec;")})
    private static Codec<MapItemSavedData> saveCodec(Codec<MapItemSavedData> codec) {
        return StationMarker.WrapperCodec.get(codec);
    }

    @Override
    public Map<String, StationMarker> create$getStationMarkers() {
        return this.create$stationMarkers;
    }

    @Override
    public void create$addStationMarker(StationMarker marker) {
        MapDecoration oldDecoration;
        this.create$stationMarkers.put(marker.getId(), marker);
        int scaleMultiplier = 1 << this.scale;
        float localX = (float)(marker.getTarget().getX() - this.centerX) / (float)scaleMultiplier;
        float localZ = (float)(marker.getTarget().getZ() - this.centerZ) / (float)scaleMultiplier;
        if (localX < -63.0f || localX > 63.0f || localZ < -63.0f || localZ > 63.0f) {
            this.removeDecoration(marker.getId());
            return;
        }
        byte localXByte = (byte)(localX * 2.0f + 0.5f);
        byte localZByte = (byte)(localZ * 2.0f + 0.5f);
        MapDecoration decoration = StationMarker.createStationDecoration(localXByte, localZByte, Optional.of(marker.getName()));
        if (!decoration.equals((Object)(oldDecoration = this.decorations.put(marker.getId(), decoration)))) {
            if (oldDecoration != null && ((MapDecorationType)oldDecoration.type().value()).trackCount()) {
                --this.trackedDecorationCount;
            }
            if (((MapDecorationType)decoration.type().value()).trackCount()) {
                ++this.trackedDecorationCount;
            }
            this.setDecorationsDirty();
        }
    }

    @Shadow
    protected abstract void removeDecoration(String var1);

    @Shadow
    protected abstract void setDecorationsDirty();

    @Shadow
    public abstract boolean isTrackedCountOverLimit(int var1);

    @Override
    public boolean create$toggleStation(LevelAccessor level, BlockPos pos, StationBlockEntity stationBlockEntity) {
        double xCenter = (double)pos.getX() + 0.5;
        double zCenter = (double)pos.getZ() + 0.5;
        int scaleMultiplier = 1 << this.scale;
        double localX = (xCenter - (double)this.centerX) / (double)scaleMultiplier;
        double localZ = (zCenter - (double)this.centerZ) / (double)scaleMultiplier;
        if (localX < -63.0 || localX > 63.0 || localZ < -63.0 || localZ > 63.0) {
            return false;
        }
        StationMarker marker = StationMarker.fromWorld((BlockGetter)level, pos);
        if (marker == null) {
            return false;
        }
        if (this.create$stationMarkers.remove(marker.getId(), marker)) {
            this.removeDecoration(marker.getId());
            return true;
        }
        if (!this.isTrackedCountOverLimit(256)) {
            this.create$addStationMarker(marker);
            return true;
        }
        return false;
    }

    @Inject(method={"checkBanners(Lnet/minecraft/world/level/BlockGetter;II)V"}, at={@At(value="RETURN")})
    public void create$onCheckBanners(BlockGetter blockGetter, int x, int z, CallbackInfo ci) {
        this.create$checkStations(blockGetter, x, z);
    }

    @Unique
    private void create$checkStations(BlockGetter blockGetter, int x, int z) {
        Iterator<StationMarker> iterator = this.create$stationMarkers.values().iterator();
        ArrayList<StationMarker> newMarkers = new ArrayList<StationMarker>();
        while (iterator.hasNext()) {
            StationMarker other;
            StationMarker marker = iterator.next();
            if (marker.getTarget().getX() != x || marker.getTarget().getZ() != z || marker.equals(other = StationMarker.fromWorld(blockGetter, marker.getSource()))) continue;
            iterator.remove();
            this.removeDecoration(marker.getId());
            if (other == null || !marker.getTarget().equals((Object)other.getTarget())) continue;
            newMarkers.add(other);
        }
        for (StationMarker marker : newMarkers) {
            this.create$addStationMarker(marker);
        }
    }
}

