/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.content.contraptions.minecart.MinecartCouplingItem;
import com.zurrtum.create.content.contraptions.mounted.MinecartContraptionItem;
import com.zurrtum.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.zurrtum.create.foundation.item.CustomAttackSoundItem;
import com.zurrtum.create.foundation.item.DamageControlItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Inject(method={"interactOn(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;", ordinal=0)}, cancellable=true)
    private void interact(Entity entity, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Player player = (Player)this;
        InteractionResult result = MinecartCouplingItem.handleInteractionWithMinecart(player, hand, entity);
        if (result != null) {
            cir.setReturnValue((Object)result);
        }
        if ((result = MinecartContraptionItem.wrenchCanBeUsedToPickUpMinecartContraptions(player, hand, entity)) != null) {
            cir.setReturnValue((Object)result);
        }
    }

    @Inject(method={"itemAttackInteraction(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/damagesource/DamageSource;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtEnemy(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/LivingEntity;)Z")})
    private void attack(Entity entity, ItemStack attackingItemStack, DamageSource damageSource, boolean applyToTarget, CallbackInfo ci) {
        ExtendoGripItem.postDamageEntity((Player)this);
    }

    @WrapOperation(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurtOrSimulate(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private boolean damage(Entity entity, DamageSource source, float amount, Operation<Boolean> original, @Local ItemStack stack) {
        DamageControlItem item;
        Item item2 = stack.getItem();
        if (item2 instanceof DamageControlItem && !(item = (DamageControlItem)item2).damage(entity)) {
            return true;
        }
        return (Boolean)original.call(new Object[]{entity, source, Float.valueOf(amount)});
    }

    @WrapOperation(method={"itemAttackInteraction(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/damagesource/DamageSource;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;postHurtEnemy(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/LivingEntity;)V")})
    private void postDamageEntity(ItemStack stack, LivingEntity target, LivingEntity user, Operation<Void> original) {
        DamageControlItem item;
        Item item2 = stack.getItem();
        if (item2 instanceof DamageControlItem && !(item = (DamageControlItem)item2).damage((Entity)target)) {
            return;
        }
        original.call(new Object[]{stack, target, user});
    }

    @WrapOperation(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;playServerSideSound(Lnet/minecraft/sounds/SoundEvent;)V")})
    private void playSound(Player player, SoundEvent sound, Operation<Void> original, @Local ItemStack attackingItemStack) {
        Item item = attackingItemStack.getItem();
        if (item instanceof CustomAttackSoundItem) {
            CustomAttackSoundItem item2 = (CustomAttackSoundItem)item;
            item2.playSound(player.level(), player, player.getX(), player.getY(), player.getZ(), sound, player.getSoundSource(), 1.0f, 1.0f);
        } else {
            original.call(new Object[]{player, sound});
        }
    }

    @WrapOperation(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;attackVisualEffects(Lnet/minecraft/world/entity/Entity;ZZZF)V")})
    private void playSound(Player player, Entity entity, boolean criticalAttack, boolean sweepAttack, boolean fullStrengthAttack, float magicBoost, Operation<Void> original, @Local ItemStack attackingItemStack) {
        Item item = attackingItemStack.getItem();
        if (item instanceof CustomAttackSoundItem) {
            Object sound;
            CustomAttackSoundItem item2 = (CustomAttackSoundItem)item;
            if (criticalAttack) {
                sound = SoundEvents.PLAYER_ATTACK_CRIT;
                player.crit(entity);
            } else {
                sound = !sweepAttack ? (fullStrengthAttack ? SoundEvents.PLAYER_ATTACK_STRONG : SoundEvents.PLAYER_ATTACK_WEAK) : null;
            }
            if (sound != null) {
                item2.playSound(player.level(), player, player.getX(), player.getY(), player.getZ(), (SoundEvent)sound, player.getSoundSource(), 1.0f, 1.0f);
                original.call(new Object[]{player, entity, false, true, fullStrengthAttack, Float.valueOf(magicBoost)});
                return;
            }
        }
        original.call(new Object[]{player, entity, criticalAttack, sweepAttack, fullStrengthAttack, Float.valueOf(magicBoost)});
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="TAIL")})
    private void writeCustomData(ValueOutput view, CallbackInfo ci) {
        CompoundTag compound = AllSynchedDatas.TOOLBOX.get((Entity)((Player)this));
        if (!compound.isEmpty()) {
            view.store("CreateToolboxData", CompoundTag.CODEC, (Object)compound);
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="TAIL")})
    private void readCustomData(ValueInput view, CallbackInfo ci) {
        view.read("CreateToolboxData", CompoundTag.CODEC).ifPresent(compound -> AllSynchedDatas.TOOLBOX.set((Entity)((Player)this), (CompoundTag)compound));
    }
}

