package com.zurrtum.create.catnip.levelWrappers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.attribute.EnvironmentAttributeSystem;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;

public class SchematicChunkSource extends ChunkSource {
    private final Level fallbackWorld;

    public SchematicChunkSource(Level world) {
        fallbackWorld = world;
    }

    @Nullable
    @Override
    public ChunkAccess getChunkForLighting(int x, int z) {
        return new EmptierChunk(fallbackWorld);
    }

    @Override
    public Level getLevel() {
        return fallbackWorld;
    }

    @Nullable
    @Override
    public ChunkAccess getChunk(int x, int z, ChunkStatus status, boolean p_212849_4_) {
        return getChunkForLighting(x, z);
    }

    @Override
    public String gatherStats() {
        return "WrappedChunkProvider";
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return fallbackWorld.getLightEngine();
    }

    @Override
    public void tick(BooleanSupplier p_202162_, boolean p_202163_) {
    }

    @Override
    public int getLoadedChunksCount() {
        return 0;
    }

    public static class EmptierChunk extends LevelChunk {

        private static final class DummyLevel extends Level {
            private DummyLevel(
                WritableLevelData pLevelData,
                ResourceKey<Level> pDimension,
                RegistryAccess pRegistryAccess,
                Holder<DimensionType> pDimensionTypeRegistration,
                EnvironmentAttributeSystem pEnvironmentAttributes,
                boolean pIsClientSide,
                boolean pIsDebug,
                long pBiomeZoomSeed,
                int pMaxChainedNeighborUpdates
            ) {
                super(
                    pLevelData,
                    pDimension,
                    pRegistryAccess,
                    pDimensionTypeRegistration,
                    pIsClientSide,
                    pIsDebug,
                    pBiomeZoomSeed,
                    pMaxChainedNeighborUpdates
                );
                access = pRegistryAccess;
                environmentAttributes = pEnvironmentAttributes;
            }

            private final RegistryAccess access;
            private final EnvironmentAttributeSystem environmentAttributes;
            private final WorldBorder border = new WorldBorder();

            private DummyLevel(Level level) {
                this(null, null, level.registryAccess(), level.dimensionTypeRegistration(), level.environmentAttributes(), false, false, 0, 0);
            }

            @Override
            public EnvironmentAttributeSystem environmentAttributes() {
                return environmentAttributes;
            }

            @Override
            public void setRespawnData(LevelData.RespawnData spawnPoint) {
            }

            @Override
            public LevelData.RespawnData getRespawnData() {
                return levelData.getRespawnData();
            }

            @Override
            public WorldBorder getWorldBorder() {
                return border;
            }

            @Override
            public ChunkSource getChunkSource() {
                return null;
            }

            @Override
            public void levelEvent(Entity pPlayer, int pType, BlockPos pPos, int pData) {
            }

            @Override
            public void gameEvent(@Nullable Entity entity, Holder<GameEvent> gameEvent, Vec3 pos) {
            }

            @Override
            public void gameEvent(Holder<GameEvent> holder, Vec3 vec3, GameEvent.Context context) {
            }

            @Override
            public RegistryAccess registryAccess() {
                return access;
            }

            @Override
            public PotionBrewing potionBrewing() {
                return null;
            }

            @Override
            public FuelValues fuelValues() {
                return null;
            }

            @Override
            public List<? extends Player> players() {
                return null;
            }

            @Override
            public Holder<Biome> getUncachedNoiseBiome(int pX, int pY, int pZ) {
                return null;
            }

            @Override
            public int getSeaLevel() {
                return 63;
            }

            @Override
            public float getShade(Direction pDirection, boolean pShade) {
                return 0;
            }

            @Override
            public void sendBlockUpdated(BlockPos pPos, BlockState pOldState, BlockState pNewState, int pFlags) {
            }

            @Override
            public void playSound(
                Entity pPlayer,
                double pX,
                double pY,
                double pZ,
                SoundEvent pSound,
                SoundSource pCategory,
                float pVolume,
                float pPitch
            ) {
            }

            @Override
            public void playSound(Entity pPlayer, Entity pEntity, SoundEvent pEvent, SoundSource pCategory, float pVolume, float pPitch) {
            }

            @Override
            public void explode(
                @Nullable Entity entity,
                @Nullable DamageSource damageSource,
                @Nullable ExplosionDamageCalculator behavior,
                double x,
                double y,
                double z,
                float power,
                boolean createFire,
                ExplosionInteraction explosionSourceType,
                ParticleOptions smallParticle,
                ParticleOptions largeParticle,
                WeightedList<ExplosionParticleInfo> blockParticles,
                Holder<SoundEvent> soundEvent
            ) {
            }

            @Override
            public void playSeededSound(
                Entity pPlayer,
                double pX,
                double pY,
                double pZ,
                Holder<SoundEvent> pSound,
                SoundSource pSource,
                float pVolume,
                float pPitch,
                long pSeed
            ) {
            }

            @Override
            public void playSeededSound(
                Entity p_220363_,
                double p_220364_,
                double p_220365_,
                double p_220366_,
                SoundEvent p_220367_,
                SoundSource p_220368_,
                float p_220369_,
                float p_220370_,
                long p_220371_
            ) {
            }

            @Override
            public void playSeededSound(
                Entity p_220372_,
                Entity p_220373_,
                Holder<SoundEvent> p_220374_,
                SoundSource p_220375_,
                float p_220376_,
                float p_220377_,
                long p_220378_
            ) {
            }

            @Override
            public String gatherChunkSourceStats() {
                return null;
            }

            @Override
            public Entity getEntity(int pId) {
                return null;
            }

            @Override
            public Collection<EnderDragonPart> dragonParts() {
                return List.of();
            }

            @Nullable
            @Override
            public MapItemSavedData getMapData(MapId mapId) {
                return null;
            }

            @Override
            public void destroyBlockProgress(int pBreakerId, BlockPos pPos, int pProgress) {
            }

            @Override
            public Scoreboard getScoreboard() {
                return null;
            }

            @Override
            public RecipeAccess recipeAccess() {
                return null;
            }

            @Override
            public LevelEntityGetter<Entity> getEntities() {
                return null;
            }

            @Override
            public LevelTickAccess<Block> getBlockTicks() {
                return BlackholeTickAccess.emptyLevelList();
            }

            @Override
            public LevelTickAccess<Fluid> getFluidTicks() {
                return BlackholeTickAccess.emptyLevelList();
            }

            @Override
            public FeatureFlagSet enabledFeatures() {
                return FeatureFlagSet.of();
            }

            @Override
            public TickRateManager tickRateManager() {
                return null;
            }
        }

        public EmptierChunk(Level level) {
            super(new DummyLevel(level), ChunkPos.ZERO);
        }

        @Override
        public BlockState getBlockState(BlockPos p_180495_1_) {
            return Blocks.VOID_AIR.defaultBlockState();
        }

        @Nullable
        public BlockState setBlockState(BlockPos p_177436_1_, BlockState p_177436_2_, boolean p_177436_3_) {
            return null;
        }

        @Override
        public FluidState getFluidState(BlockPos p_204610_1_) {
            return Fluids.EMPTY.defaultFluidState();
        }

        @Override
        public int getLightEmission(BlockPos p_217298_1_) {
            return 0;
        }

        @Nullable
        public BlockEntity getBlockEntity(BlockPos p_177424_1_, EntityCreationType p_177424_2_) {
            return null;
        }

        @Override
        public void addAndRegisterBlockEntity(BlockEntity p_150813_1_) {
        }

        @Override
        public void setBlockEntity(BlockEntity p_177426_2_) {
        }

        @Override
        public void removeBlockEntity(BlockPos p_177425_1_) {
        }

        public void markUnsaved() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isYSpaceEmpty(int p_76606_1_, int p_76606_2_) {
            return true;
        }

        @Override
        public FullChunkStatus getFullStatus() {
            return FullChunkStatus.FULL;
        }
    }
}
