package com.zurrtum.create.client.content.equipment.zapper.terrainzapper;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.Brush;
import com.zurrtum.create.infrastructure.component.PlacementOptions;
import com.zurrtum.create.infrastructure.component.TerrainBrushes;
import com.zurrtum.create.infrastructure.component.TerrainTools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ClipContext.Block;
import net.minecraft.world.level.ClipContext.Fluid;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult.Type;
import net.minecraft.world.phys.Vec3;

public class WorldshaperRenderHandler {

    private static Supplier<Collection<BlockPos>> renderedPositions;

    public static void tick(Minecraft mc) {
        gatherSelectedBlocks(mc);
        if (renderedPositions == null)
            return;

        Outliner.getInstance().showCluster("terrainZapper", renderedPositions.get()).colored(0xbfbfbf).disableLineNormals().lineWidth(1 / 32f)
            .withFaceTexture(AllSpecialTextures.CHECKERED);
    }

    protected static void gatherSelectedBlocks(Minecraft mc) {
        LocalPlayer player = mc.player;
        ItemStack heldMain = player.getMainHandItem();
        ItemStack heldOff = player.getOffhandItem();
        boolean zapperInMain = heldMain.is(AllItems.WORLDSHAPER);
        boolean zapperInOff = heldOff.is(AllItems.WORLDSHAPER);

        if (zapperInMain) {
            if (!heldMain.has(AllDataComponents.SHAPER_SWAP) || !zapperInOff) {
                createBrushOutline(player, heldMain);
                return;
            }
        }

        if (zapperInOff) {
            createBrushOutline(player, heldOff);
            return;
        }

        renderedPositions = null;
    }

    public static void createBrushOutline(LocalPlayer player, ItemStack zapper) {
        if (!zapper.has(AllDataComponents.SHAPER_BRUSH_PARAMS)) {
            renderedPositions = null;
            return;
        }

        Brush brush = zapper.getOrDefault(AllDataComponents.SHAPER_BRUSH, TerrainBrushes.Cuboid).get();
        PlacementOptions placement = zapper.getOrDefault(AllDataComponents.SHAPER_PLACEMENT_OPTIONS, PlacementOptions.Merged);
        TerrainTools tool = zapper.getOrDefault(AllDataComponents.SHAPER_TOOL, TerrainTools.Fill);
        BlockPos params = zapper.get(AllDataComponents.SHAPER_BRUSH_PARAMS);
        brush.set(params.getX(), params.getY(), params.getZ());

        Vec3 start = player.position().add(0, player.getEyeHeight(), 0);
        Vec3 rotationVector = player.getLookAngle();
        Vec3 range = rotationVector.scale(128);
        Level world = player.level();
        BlockHitResult raytrace = world.clip(new ClipContext(start, start.add(range), Block.OUTLINE, Fluid.NONE, player));
        if (raytrace == null || raytrace.getType() == Type.MISS) {
            renderedPositions = null;
            return;
        }

        BlockPos pos = raytrace.getBlockPos().offset(brush.getOffset(rotationVector, raytrace.getDirection(), placement));
        renderedPositions = () -> brush.addToGlobalPositions(world, pos, raytrace.getDirection(), new ArrayList<>(), tool);
    }

}