package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.google.common.cache.Cache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.logistics.packagePort.PackagePortTargetSelectionHandler;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.packagePort.PackagePortTarget;
import com.zurrtum.create.foundation.utility.TickBasedCache;
import com.zurrtum.create.infrastructure.packet.c2s.ChainConveyorConnectionPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ChainPackageInteractionPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

import java.util.List;
import java.util.Map;

public class ChainConveyorInteractionHandler {

    public static WorldAttached<Cache<BlockPos, List<ChainConveyorShape>>> loadedChains = new WorldAttached<>($ -> new TickBasedCache<>(60, true));

    public static BlockPos selectedLift;
    public static float selectedChainPosition;
    public static BlockPos selectedConnection;
    public static Vec3 selectedBakedPosition;
    public static ChainConveyorShape selectedShape;

    public static void clientTick(Minecraft mc) {
        if (!isActive(mc)) {
            selectedLift = null;
            return;
        }

        LocalPlayer player = mc.player;
        boolean isWrench = player.isHolding(i -> i.is(AllItemTags.TOOLS_WRENCH));
        boolean dismantling = isWrench && player.isShiftKeyDown();
        double range = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 1;

        Vec3 from = player.getEyePosition();
        Vec3 to = RaycastHelper.getTraceTarget(player, range, from);
        HitResult hitResult = mc.hitResult;

        double bestDiff = Float.MAX_VALUE;
        if (hitResult != null)
            bestDiff = hitResult.getLocation().distanceToSqr(from);

        BlockPos bestLift = null;
        ChainConveyorShape bestShape = null;
        selectedConnection = null;

        for (Map.Entry<BlockPos, List<ChainConveyorShape>> entry : loadedChains.get(mc.level).asMap().entrySet()) {
            BlockPos liftPos = entry.getKey();
            for (ChainConveyorShape chainConveyorShape : entry.getValue()) {
                if (chainConveyorShape instanceof ChainConveyorShape.ChainConveyorBB && dismantling)
                    continue;
                Vec3 liftVec = Vec3.atLowerCornerOf(liftPos);
                Vec3 intersect = chainConveyorShape.intersect(from.subtract(liftVec), to.subtract(liftVec));
                if (intersect == null)
                    continue;

                double distanceToSqr = intersect.add(liftVec).distanceToSqr(from);
                if (distanceToSqr > bestDiff)
                    continue;
                bestDiff = distanceToSqr;
                bestLift = liftPos;
                bestShape = chainConveyorShape;
                selectedChainPosition = chainConveyorShape.getChainPosition(intersect);
                if (chainConveyorShape instanceof ChainConveyorShape.ChainConveyorOBB obb)
                    selectedConnection = obb.connection;
            }
        }

        selectedLift = bestLift;
        if (bestLift == null)
            return;

        selectedShape = bestShape;
        selectedBakedPosition = bestShape.getVec(bestLift, selectedChainPosition);

        if (!isWrench) {
            Outliner.getInstance().chaseAABB("ChainPointSelection", new AABB(selectedBakedPosition, selectedBakedPosition)).colored(Color.WHITE)
                .lineWidth(1 / 6f).disableLineNormals();
        }
    }

    private static boolean isActive(Minecraft mc) {
        ItemStack mainHandItem = mc.player.getMainHandItem();
        return mc.player.isHolding(i -> i.is(AllItemTags.CHAIN_RIDEABLE)) || mainHandItem.is(AllItems.PACKAGE_FROGPORT) || PackageItem.isPackage(
            mainHandItem);
    }

    public static boolean onUse(Minecraft mc) {
        if (selectedLift == null)
            return false;

        LocalPlayer player = mc.player;
        ItemStack mainHandItem = player.getMainHandItem();

        if (player.isHolding(i -> i.is(AllItemTags.CHAIN_RIDEABLE))) {
            ItemStack usedItem = mainHandItem.is(AllItemTags.CHAIN_RIDEABLE) ? mainHandItem : player.getOffhandItem();
            if (!player.isShiftKeyDown()) {
                ChainConveyorRidingHandler.embark(mc, selectedLift, selectedChainPosition, selectedConnection);
                return true;
            }

            player.connection.send(new ChainConveyorConnectionPacket(selectedLift, selectedLift.offset(selectedConnection), usedItem, false));
            return true;
        }

        if (mainHandItem.is(AllItems.PACKAGE_FROGPORT)) {
            PackagePortTargetSelectionHandler.exactPositionOfTarget = selectedBakedPosition;
            PackagePortTargetSelectionHandler.activePackageTarget = new PackagePortTarget.ChainConveyorFrogportTarget(
                selectedLift,
                selectedChainPosition,
                selectedConnection,
                false
            );
            return true;
        }

        if (PackageItem.isPackage(mainHandItem)) {
            player.connection.send(new ChainPackageInteractionPacket(
                selectedLift,
                selectedConnection == null ? BlockPos.ZERO : selectedConnection,
                selectedChainPosition,
                false
            ));
            return true;
        }

        return true;
    }

    public static void drawCustomBlockSelection(PoseStack ms, MultiBufferSource buffer, Vec3 camera) {
        if (selectedLift == null || selectedShape == null)
            return;

        VertexConsumer vb = buffer.getBuffer(RenderTypes.lines());
        ms.pushPose();
        ms.translate(selectedLift.getX() - camera.x, selectedLift.getY() - camera.y, selectedLift.getZ() - camera.z);
        selectedShape.drawOutline(selectedLift, ms, vb);
        ms.popPose();
    }

    public static boolean hideVanillaBlockSelection() {
        return selectedLift != null && selectedShape != null;
    }

}
