package com.zurrtum.create.client.flywheel.lib.vertex;

import org.lwjgl.system.MemoryUtil;

public class PosVertexView extends AbstractVertexView implements DefaultVertexList {
    public static final long STRIDE = 12;

    @Override
    public long stride() {
        return STRIDE;
    }

    @Override
    public float x(int index) {
        return MemoryUtil.memGetFloat(ptr + index * STRIDE);
    }

    @Override
    public float y(int index) {
        return MemoryUtil.memGetFloat(ptr + index * STRIDE + 4);
    }

    @Override
    public float z(int index) {
        return MemoryUtil.memGetFloat(ptr + index * STRIDE + 8);
    }

    @Override
    public void x(int index, float x) {
        MemoryUtil.memPutFloat(ptr + index * STRIDE, x);
    }

    @Override
    public void y(int index, float y) {
        MemoryUtil.memPutFloat(ptr + index * STRIDE + 4, y);
    }

    @Override
    public void z(int index, float z) {
        MemoryUtil.memPutFloat(ptr + index * STRIDE + 8, z);
    }
}
