package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.ContraptionHandler;
import com.zurrtum.create.infrastructure.fluids.FlowableFluid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.lang.ref.Reference;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Mixin(Entity.class)
public abstract class EntityMixin {
    @Shadow
    private Level level;
    @Shadow
    private Vec3 position;
    @Shadow
    private float nextStep;
    @Shadow
    @Final
    protected RandomSource random;
    @Shadow
    private EntityDimensions dimensions;
    @Unique
    private boolean inModFluid;

    @Shadow
    protected abstract void playStepSound(BlockPos pos, BlockState state);

    @Shadow
    protected abstract float nextStep();

    @Inject(method = "updateFluidHeightAndDoFluidPushing(Lnet/minecraft/tags/TagKey;D)Z", at = @At("HEAD"))
    private void clear(TagKey<Fluid> tag, double speed, CallbackInfoReturnable<Boolean> cir) {
        inModFluid = false;
    }

    @Inject(method = "updateFluidHeightAndDoFluidPushing(Lnet/minecraft/tags/TagKey;D)Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/material/FluidState;getHeight(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F"))
    private void checkFluid(TagKey<Fluid> tag, double speed, CallbackInfoReturnable<Boolean> cir, @Local FluidState state) {
        if (!inModFluid) {
            inModFluid = state.getType() instanceof FlowableFluid;
        }
    }

    @Inject(method = "doWaterSplashEffect()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"), cancellable = true)
    private void cancelEffect(CallbackInfo ci) {
        if (inModFluid) {
            ci.cancel();
        }
    }

    @Unique
    private Stream<AbstractContraptionEntity> create$getIntersectionContraptionsStream() {
        return (level.isClientSide() ? ContraptionHandlerClient.loadedContraptions : ContraptionHandler.loadedContraptions).get(level).values()
            .stream().map(Reference::get).filter(cEntity -> cEntity != null && cEntity.collidingEntities.containsKey((Entity) (Object) this));
    }

    @Unique
    private Set<AbstractContraptionEntity> create$getIntersectingContraptions() {
        Set<AbstractContraptionEntity> contraptions = create$getIntersectionContraptionsStream().collect(Collectors.toSet());

        contraptions.addAll(level.getEntitiesOfClass(AbstractContraptionEntity.class, ((Entity) (Object) this).getBoundingBox().inflate(1f)));
        return contraptions;
    }

    @Unique
    private void create$forCollision(Vec3 worldPos, TriConsumer<Contraption, BlockState, BlockPos> action) {
        create$getIntersectingContraptions().forEach(cEntity -> {
            Vec3 localPos = ContraptionCollider.worldToLocalPos(worldPos, cEntity);

            BlockPos blockPos = BlockPos.containing(localPos);
            Contraption contraption = cEntity.getContraption();
            StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(blockPos);

            if (info != null) {
                BlockState blockstate = info.state();
                action.accept(contraption, blockstate, blockPos);
            }
        });
    }

    // involves block step sounds on contraptions
    // injecting before `!blockstate1.isAir(this.world, blockpos)`
    // `if (this.moveDist > this.nextStep && !blockstate1.isAir())
    @Inject(method = "applyMovementEmissionAndPlaySound(Lnet/minecraft/world/entity/Entity$MovementEmission;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/state/BlockState;isAir()Z", ordinal = 0))
    private void create$contraptionStepSounds(
        Entity.MovementEmission moveEffect,
        Vec3 movement,
        BlockPos landingPos,
        BlockState landingState,
        CallbackInfo ci
    ) {
        Vec3 worldPos = position.add(0, -0.2, 0);
        MutableBoolean stepped = new MutableBoolean(false);

        create$forCollision(
            worldPos, (contraption, state, pos) -> {
                playStepSound(pos, state);
                stepped.setTrue();
            }
        );

        if (stepped.booleanValue())
            nextStep = nextStep();
    }

    // involves client-side view bobbing animation on contraptions
    @Inject(method = "move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V", at = @At(value = "TAIL"))
    private void create$onMove(MoverType type, Vec3 movement, CallbackInfo ci) {
        if (!level.isClientSide())
            return;
        Entity self = (Entity) (Object) this;
        if (self.onGround())
            return;
        if (self.isPassenger())
            return;

        Vec3 worldPos = position.add(0, -0.2, 0);
        boolean onAtLeastOneContraption = create$getIntersectionContraptionsStream().anyMatch(cEntity -> {
            Vec3 localPos = ContraptionCollider.worldToLocalPos(worldPos, cEntity);

            BlockPos blockPos = BlockPos.containing(localPos);
            Contraption contraption = cEntity.getContraption();
            StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(blockPos);

            if (info == null)
                return false;

            cEntity.registerColliding(self);
            return true;
        });

        if (!onAtLeastOneContraption)
            return;

        self.setOnGround(true);
        AllSynchedDatas.CONTRAPTION_GROUNDED.set(self, true);
    }

    @Inject(method = "spawnSprintParticle()V", at = @At(value = "TAIL"))
    private void create$onSpawnSprintParticle(CallbackInfo ci) {
        Entity self = (Entity) (Object) this;
        Vec3 worldPos = position.add(0, -0.2, 0);

        create$forCollision(
            worldPos, (contraption, state, pos) -> {
                if (state.getRenderShape() != RenderShape.INVISIBLE) {
                    Vec3 speed = self.getDeltaMovement();
                    level.addParticle(
                        new BlockParticleOption(ParticleTypes.BLOCK, state),
                        self.getX() + ((double) random.nextFloat() - 0.5D) * (double) dimensions.width(),
                        self.getY() + 0.1D,
                        self.getZ() + ((double) random.nextFloat() - 0.5D) * (double) dimensions.height(),
                        speed.x * -4.0D,
                        1.5D,
                        speed.z * -4.0D
                    );
                }
            }
        );
    }

    @WrapOperation(method = "move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;canSimulateMovement()Z"))
    private boolean move(Entity instance, Operation<Boolean> original) {
        if (original.call(instance)) {
            return true;
        }
        return level instanceof PonderLevel;
    }
}
