package com.zurrtum.create.content.contraptions.bearing;

import com.zurrtum.create.AllContraptionTypes;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.Contraption;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class StabilizedContraption extends Contraption {

    private Direction facing;

    public StabilizedContraption() {
    }

    public StabilizedContraption(Direction facing) {
        this.facing = facing;
    }

    @Override
    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        BlockPos offset = pos.relative(facing);
        if (!searchMovedStructure(world, offset, null))
            return false;
        startMoving(world);
        if (blocks.isEmpty())
            return false;
        return true;
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return false;
    }

    @Override
    public ContraptionType getType() {
        return AllContraptionTypes.STABILIZED;
    }

    @Override
    public void write(ValueOutput view, boolean spawnPacket) {
        super.write(view, spawnPacket);
        view.putInt("Facing", facing.get3DDataValue());
    }

    @Override
    public void read(Level world, ValueInput view, boolean spawnData) {
        facing = Direction.from3DDataValue(view.getIntOr("Facing", 0));
        super.read(world, view, spawnData);
    }

    @Override
    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        return false;
    }

    public Direction getFacing() {
        return facing;
    }

}
