package com.zurrtum.create.content.contraptions.behaviour;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.CampfireBlock;

public class CampfireMovementBehaviour extends MovementBehaviour {
    @Override
    public void tick(MovementContext context) {
        if (context.world == null || !context.world.isClientSide() || context.position == null || !context.state.getValue(CampfireBlock.LIT) || context.disabled)
            return;

        // Mostly copied from CampfireBlock and CampfireBlockEntity
        RandomSource random = context.world.random;
        if (random.nextFloat() < 0.11F) {
            for (int i = 0; i < random.nextInt(2) + 2; ++i) {
                context.world.addAlwaysVisibleParticle(
                    context.state.getValue(CampfireBlock.SIGNAL_FIRE) ? ParticleTypes.CAMPFIRE_SIGNAL_SMOKE : ParticleTypes.CAMPFIRE_COSY_SMOKE,
                    true,
                    context.position.x() + random.nextDouble() / (random.nextBoolean() ? 3D : -3D),
                    context.position.y() + random.nextDouble() + random.nextDouble(),
                    context.position.z() + random.nextDouble() / (random.nextBoolean() ? 3D : -3D),
                    0.0D,
                    0.07D,
                    0.0D
                );
            }
        }
    }
}