package com.zurrtum.create.content.equipment.blueprint;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class BlueprintItem extends Item {

    public BlueprintItem(Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult useOn(UseOnContext ctx) {
        Direction face = ctx.getClickedFace();
        Player player = ctx.getPlayer();
        ItemStack stack = ctx.getItemInHand();
        BlockPos pos = ctx.getClickedPos().relative(face);

        if (player != null && !player.mayUseItemAt(pos, face, stack))
            return InteractionResult.FAIL;

        Level world = ctx.getLevel();
        HangingEntity hangingentity = new BlueprintEntity(
            world,
            pos,
            face,
            face.getAxis().isHorizontal() ? Direction.DOWN : ctx.getHorizontalDirection()
        );
        CustomData customData = stack.get(DataComponents.CUSTOM_DATA);

        if (customData != null)
            EntityType.updateCustomEntityTag(world, player, hangingentity, TypedEntityData.of(hangingentity.getType(), customData.copyTag()));
        if (!hangingentity.survives())
            return InteractionResult.CONSUME;
        if (!world.isClientSide()) {
            hangingentity.playPlacementSound();
            world.addFreshEntity(hangingentity);
        }

        stack.shrink(1);
        return InteractionResult.SUCCESS;
    }

    //TODO
    //    public static void assignCompleteRecipe(World level, ItemStackHandler inv, Recipe<?> recipe) {
    //        NonNullList<Ingredient> ingredients = recipe.getIngredients();
    //
    //        for (int i = 0; i < 9; i++)
    //            inv.setStackInSlot(i, ItemStack.EMPTY);
    //        inv.setStackInSlot(9, recipe.getResultItem(level.registryAccess()));
    //
    //        if (recipe instanceof ShapedRecipe shapedRecipe) {
    //            for (int row = 0; row < shapedRecipe.getHeight(); row++)
    //                for (int col = 0; col < shapedRecipe.getWidth(); col++)
    //                    inv.setStackInSlot(row * 3 + col, convertIngredientToFilter(ingredients.get(row * shapedRecipe.getWidth() + col)));
    //        } else {
    //            for (int i = 0; i < ingredients.size(); i++)
    //                inv.setStackInSlot(i, convertIngredientToFilter(ingredients.get(i)));
    //        }
    //    }
    //
    //    private static ItemStack convertIngredientToFilter(Ingredient ingredient) {
    //        boolean isCompoundIngredient = ingredient.getCustomIngredient() instanceof CompoundIngredient;
    //        Ingredient.Value[] acceptedItems = ingredient.values;
    //        if (acceptedItems == null || acceptedItems.length > 18)
    //            return ItemStack.EMPTY;
    //        if (acceptedItems.length == 0)
    //            return ItemStack.EMPTY;
    //        if (acceptedItems.length == 1)
    //            return convertIItemListToFilter(acceptedItems[0], isCompoundIngredient);
    //
    //        ItemStack result = AllItems.FILTER.asStack();
    //        ItemStackHandler filterItems = AllItems.FILTER.getFilterItemHandler(result);
    //        for (int i = 0; i < acceptedItems.length; i++)
    //            filterItems.setStackInSlot(i, convertIItemListToFilter(acceptedItems[i], isCompoundIngredient));
    //        result.set(AllDataComponents.FILTER_ITEMS, ItemHelper.containerContentsFromHandler(filterItems));
    //        return result;
    //    }
    //
    //    private static ItemStack convertIItemListToFilter(Value itemList, boolean isCompoundIngredient) {
    //        Collection<ItemStack> stacks = itemList.getItems();
    //        if (itemList instanceof ItemValue) {
    //            for (ItemStack itemStack : stacks)
    //                return itemStack;
    //        }
    //
    //        if (itemList instanceof TagValue tagValue) {
    //            ItemStack filterItem = AllItems.ATTRIBUTE_FILTER.asStack();
    //            filterItem.set(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE, AttributeFilterWhitelistMode.WHITELIST_DISJ);
    //            List<ItemAttributeEntry> attributes = new ArrayList<>();
    //            ItemAttribute at = new InTagAttribute(ItemTags.create(tagValue.tag().location()));
    //            attributes.add(new ItemAttribute.ItemAttributeEntry(at, false));
    //            filterItem.set(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES, attributes);
    //            return filterItem;
    //        }
    //
    //        if (isCompoundIngredient) {
    //            ItemStack result = AllItems.FILTER.asStack();
    //            ItemStackHandler filterItems = AllItems.FILTER.getFilterItemHandler(result);
    //            int i = 0;
    //            for (ItemStack itemStack : stacks) {
    //                if (i >= 18)
    //                    break;
    //                filterItems.setStackInSlot(i++, itemStack);
    //            }
    //            result.set(AllDataComponents.FILTER_ITEMS, ItemHelper.containerContentsFromHandler(filterItems));
    //            result.set(AllDataComponents.FILTER_ITEMS_RESPECT_NBT, true);
    //            return result;
    //        }
    //
    //        return ItemStack.EMPTY;
    //    }

}