package com.zurrtum.create.content.kinetics.fan;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NozzleBlock extends WrenchableDirectionalBlock implements IBE<NozzleBlockEntity>, NeighborUpdateListeningBlock {

    public NozzleBlock(Properties p_i48415_1_) {
        super(p_i48415_1_);
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.FAIL;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return defaultBlockState().setValue(FACING, context.getClickedFace());
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.NOZZLE.get(state.getValue(FACING));
    }

    @Override
    public void neighborUpdate(BlockState state, Level worldIn, BlockPos pos, Block sourceBlock, BlockPos fromPos, boolean isMoving) {
        if (worldIn.isClientSide())
            return;

        if (fromPos.equals(pos.relative(state.getValue(FACING).getOpposite())))
            if (!canSurvive(state, worldIn, pos)) {
                worldIn.destroyBlock(pos, true);
            }
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction towardsFan = state.getValue(FACING).getOpposite();
        BlockEntity be = worldIn.getBlockEntity(pos.relative(towardsFan));
        return be instanceof IAirCurrentSource && ((IAirCurrentSource) be).getAirflowOriginSide() == towardsFan.getOpposite();
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Override
    public Class<NozzleBlockEntity> getBlockEntityClass() {
        return NozzleBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends NozzleBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.NOZZLE;
    }

}
