package com.zurrtum.create.content.logistics.depot;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SharedDepotBlockMethods {

    protected static DepotBehaviour get(BlockGetter worldIn, BlockPos pos) {
        return BlockEntityBehaviour.get(worldIn, pos, DepotBehaviour.TYPE);
    }

    public static InteractionResult onUse(
        ItemStack stack,
        BlockState state,
        Level level,
        BlockPos pos,
        Player player,
        InteractionHand hand,
        BlockHitResult ray
    ) {
        if (ray.getDirection() != Direction.UP)
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        if (level.isClientSide())
            return InteractionResult.SUCCESS;

        DepotBehaviour behaviour = get(level, pos);
        if (behaviour == null)
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        if (!behaviour.canAcceptItems.get())
            return InteractionResult.SUCCESS;

        boolean wasEmptyHanded = stack.isEmpty();
        boolean shouldntPlaceItem = stack.is(AllItems.MECHANICAL_ARM);

        ItemStack mainItemStack = behaviour.getHeldItemStack();
        if (!mainItemStack.isEmpty()) {
            if (ItemStack.isSameItemSameComponents(mainItemStack, stack)) {
                int remainder = mainItemStack.getCount();
                int count = stack.getCount();
                int extract = Math.min(remainder, stack.getMaxStackSize() - count);
                if (extract != 0) {
                    stack.setCount(count + extract);
                    if (extract == remainder) {
                        mainItemStack = ItemStack.EMPTY;
                        behaviour.removeHeldItem();
                    } else {
                        mainItemStack.setCount(remainder - extract);
                    }
                }
            }
            if (!mainItemStack.isEmpty()) {
                player.getInventory().placeItemBackInInventory(mainItemStack);
                behaviour.removeHeldItem();
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, .2f, 1f + level.getRandom().nextFloat());
            }
        }
        boolean change = false;
        Container outputs = behaviour.processingOutputBuffer;
        for (int i = 0, size = outputs.getContainerSize(); i < size; i++) {
            ItemStack itemStack = outputs.removeItemNoUpdate(i);
            if (itemStack.isEmpty()) {
                continue;
            }
            player.getInventory().placeItemBackInInventory(itemStack);
            change = true;
        }
        if (change) {
            outputs.setChanged();
        }

        if (!wasEmptyHanded && !shouldntPlaceItem) {
            TransportedItemStack transported = new TransportedItemStack(stack);
            transported.insertedFrom = player.getDirection();
            transported.prevBeltPosition = .25f;
            transported.beltPosition = .25f;
            behaviour.setHeldItem(transported);
            player.setItemInHand(hand, ItemStack.EMPTY);
            AllSoundEvents.DEPOT_SLIDE.playOnServer(level, pos);
        }

        behaviour.blockEntity.notifyUpdate();
        return InteractionResult.SUCCESS;
    }

    public static void onLanded(BlockGetter worldIn, Entity entityIn) {
        ItemStack asItem = ItemHelper.fromItemEntity(entityIn);
        if (asItem.isEmpty())
            return;
        if (entityIn.level().isClientSide())
            return;

        BlockPos pos = entityIn.blockPosition();
        DirectBeltInputBehaviour inputBehaviour = BlockEntityBehaviour.get(worldIn, pos, DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null)
            return;
        Vec3 targetLocation = VecHelper.getCenterOf(pos).add(0, 5 / 16f, 0);
        if (!PackageEntity.centerPackage(entityIn, targetLocation))
            return;

        ItemStack remainder = inputBehaviour.handleInsertion(asItem, Direction.DOWN, false);
        if (entityIn instanceof ItemEntity)
            ((ItemEntity) entityIn).setItem(remainder);
        if (remainder.isEmpty())
            entityIn.discard();
    }

    public static int getComparatorInputOverride(BlockState blockState, Level worldIn, BlockPos pos) {
        DepotBehaviour depotBehaviour = get(worldIn, pos);
        if (depotBehaviour == null)
            return 0;
        float f = depotBehaviour.getPresentStackSize();
        Integer max = depotBehaviour.maxStackSize.get();
        f = f / (max == 0 ? 64 : max);
        return Mth.clamp(Mth.floor(f * 14.0F) + (f > 0 ? 1 : 0), 0, 15);
    }

}
