package com.zurrtum.create.client.catnip.gui;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.render.BreadcrumbArrowRenderState;
import com.zurrtum.create.client.catnip.gui.render.GradientRectRenderState;
import com.zurrtum.create.client.catnip.gui.render.RadialSectorRenderState;
import com.zurrtum.create.client.catnip.gui.render.TexturedQuadRenderState;
import net.minecraft.class_10366;
import net.minecraft.class_1041;
import net.minecraft.class_10783;
import net.minecraft.class_10799;
import net.minecraft.class_10861;
import net.minecraft.class_10865;
import net.minecraft.class_10868;
import net.minecraft.class_11231;
import net.minecraft.class_11286;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import net.minecraft.client.render.*;
import org.jetbrains.annotations.Nullable;
import org.joml.*;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

import java.awt.geom.Point2D;
import java.lang.Math;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Supplier;

import static com.zurrtum.create.Create.MOD_ID;

public class UIRenderHelper {
    private static final class_11286 PROJECTION = new class_11286("UIRenderHelper");
    public static final RenderPipeline BLIT_SCREEN = RenderPipeline.builder(class_10799.field_60125)
        .withLocation(class_2960.method_60655(MOD_ID, "pipeline/blit_screen")).withVertexShader("core/blit_screen").withFragmentShader("core/blit_screen")
        .withSampler("InSampler").withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST)
        .withVertexFormat(class_290.field_1575, VertexFormat.class_5596.field_27382).build();

    public static final Couple<Color> COLOR_TEXT = Couple.create(new Color(0xff_eeeeee), new Color(0xff_a3a3a3)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_DARKER = Couple.create(new Color(0xff_a3a3a3), new Color(0xff_808080)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_ACCENT = Couple.create(new Color(0xff_ddeeff), new Color(0xff_a0b0c0)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_STRONG_ACCENT = Couple.create(new Color(0xff_8ab6d6), new Color(0xff_6e92ab))
        .map(Color::setImmutable);

    public static final Color COLOR_STREAK = new Color(0x101010, false).setImmutable();

    /**
     * An FBO that has a stencil buffer for use wherever stencil are necessary. Forcing the main FBO to have a stencil
     * buffer will cause GL error spam when using fabulous graphics.
     */
    @Nullable
    public static CustomRenderTarget framebuffer;

    public static void init() {
        RenderSystem.assertOnRenderThread();
        class_1041 mainWindow = class_310.method_1551().method_22683();
        framebuffer = CustomRenderTarget.create(mainWindow);
    }

    public static void updateWindowSize(class_1041 mainWindow) {
        if (framebuffer != null)
            framebuffer.method_1234(mainWindow.method_4489(), mainWindow.method_4506());
    }

    public static void drawFramebuffer(class_4587 poseStack, float alpha) {
        if (framebuffer != null)
            framebuffer.renderWithAlpha(poseStack, alpha);
    }

    /**
     * Switch from src to dst, after copying the contents of src to dst.
     */
    public static void swapAndBlitColor(class_276 src, class_276 dst) {
        int srcId = getFrameBufferId(src);
        int dstId = getFrameBufferId(dst);
        GlStateManager._glBindFramebuffer(GL30.GL_READ_FRAMEBUFFER, srcId);
        GlStateManager._glBindFramebuffer(GL30.GL_DRAW_FRAMEBUFFER, dstId);
        GlStateManager._glBlitFrameBuffer(
            0,
            0,
            src.field_1480,
            src.field_1477,
            0,
            0,
            dst.field_1480,
            dst.field_1477,
            GL30.GL_COLOR_BUFFER_BIT,
            GL20.GL_LINEAR
        );

        GlStateManager._glBindFramebuffer(GlConst.GL_FRAMEBUFFER, dstId);
    }

    private static int getFrameBufferId(class_276 buffer) {
        class_10868 colorAttachment = (class_10868) buffer.method_30277();
        int id = buffer.field_1478 ? ((class_10868) buffer.method_30278()).method_68427() : 0;
        return colorAttachment.field_57885.get(id);
    }

    /**
     * @param angle   angle in degrees, 0 means fading to the right
     * @param x       x-position of the starting edge middle point
     * @param y       y-position of the starting edge middle point
     * @param breadth total width of the streak
     * @param length  total length of the streak
     */
    public static void streak(class_332 graphics, float angle, int x, int y, int breadth, int length) {
        streak(graphics, angle, x, y, breadth, length, COLOR_STREAK);
    }

    public static void streak(class_332 graphics, float angle, int x, int y, int breadth, int length, Color c) {
        Color color = c.copy().setImmutable();
        Color c1 = color.scaleAlpha(0.625f);
        Color c2 = color.scaleAlpha(0.5f);
        Color c3 = color.scaleAlpha(0.0625f);
        Color c4 = color.scaleAlpha(0f);

        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(x, y);
        poseStack.rotate((float) ((angle - 90) * (Math.PI / 180.0)));

        streak(graphics, breadth / 2, length, c1, c2, c3, c4);

        poseStack.popMatrix();
    }

    private static void streak(class_332 graphics, int width, int height, Color c1, Color c2, Color c3, Color c4) {
        if (NavigatableSimiScreen.isCurrentlyRenderingPreviousScreen())
            return;

        double split1 = .5;
        double split2 = .75;
        graphics.method_25296(-width, 0, width, (int) (split1 * height), c1.getRGB(), c2.getRGB());
        graphics.method_25296(-width, (int) (split1 * height), width, (int) (split2 * height), c2.getRGB(), c3.getRGB());
        graphics.method_25296(-width, (int) (split2 * height), width, height, c3.getRGB(), c4.getRGB());
    }

    /**
     * @see #angledGradient(class_332, float, int, int, float, float, Color, Color)
     */
    public static void angledGradient(class_332 graphics, float angle, int x, int y, float breadth, float length, Couple<Color> c) {
        angledGradient(graphics, angle, x, y, breadth, length, c.getFirst(), c.getSecond());
    }

    /**
     * x and y specify the middle point of the starting edge
     *
     * @param angle      the angle of the gradient in degrees; 0° means from left to right
     * @param startColor the color at the starting edge
     * @param endColor   the color at the ending edge
     * @param breadth    the total width of the gradient
     */
    public static void angledGradient(
        class_332 graphics,
        float angle,
        int x,
        int y,
        float breadth,
        float length,
        Color startColor,
        Color endColor
    ) {
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(x, y);
        poseStack.rotate((float) ((angle - 90) * (Math.PI / 180.0)));

        float w = breadth / 2;
        //graphics.fillGradient(-w, 0, w, length, startColor.getRGB(), endColor.getRGB());
        drawGradientRect(graphics, -w, 0f, w, length, startColor, endColor);

        poseStack.popMatrix();
    }

    public static void drawGradientRect(class_332 graphics, float left, float top, float right, float bottom, Color startColor, Color endColor) {
        graphics.field_59826.method_70919(new GradientRectRenderState(
            new Matrix3x2f(graphics.method_51448()),
            left,
            top,
            right,
            bottom,
            startColor,
            endColor
        ));
    }

    public static void breadcrumbArrow(class_332 graphics, int x, int y, int width, int height, int indent, Couple<Color> colors) {
        breadcrumbArrow(graphics, x, y, width, height, indent, colors.getFirst(), colors.getSecond());
    }

    // draws a wide chevron-style breadcrumb arrow pointing left
    public static void breadcrumbArrow(class_332 graphics, int x, int y, int width, int height, int indent, Color startColor, Color endColor) {
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(x - indent, y);

        breadcrumbArrow(graphics, width, height, indent, startColor, endColor);

        poseStack.popMatrix();
    }

    private static void breadcrumbArrow(class_332 graphics, int width, int height, int indent, Color c1, Color c2) {

        /*
         * 0,0       x1,y0 ********************* x2,y0 ***** x3,y0
         *       ****                                     ****
         *   ****                                     ****
         * x0,y1     x1,y1                       x2,y1
         *   ****                                     ****
         *       ****                                     ****
         *           x1,y2 ********************* x2,y2 ***** x3,y2
         *
         */

        float x0 = 0;
        float x1 = indent;
        float x2 = width;
        float x3 = indent + width;

        float y0 = 0;
        float y1 = height / 2f;
        float y2 = height;

        indent = Math.abs(indent);
        width = Math.abs(width);
        Color fc1 = Color.mixColors(c1, c2, 0);
        Color fc2 = Color.mixColors(c1, c2, (indent) / (width + 2f * indent));
        Color fc3 = Color.mixColors(c1, c2, (indent + width) / (width + 2f * indent));
        Color fc4 = Color.mixColors(c1, c2, 1);

        graphics.field_59826.method_70919(new BreadcrumbArrowRenderState(
            new Matrix3x2f(graphics.method_51448()),
            x0,
            x1,
            x2,
            x3,
            y0,
            y1,
            y2,
            fc1,
            fc2,
            fc3,
            fc4,
            indent + width,
            height
        ));
    }

    /**
     * centered on 0, 0
     *
     * @param arcAngle length of the sector arc
     */
    public static void drawRadialSector(
        class_332 graphics,
        float innerRadius,
        float outerRadius,
        float startAngle,
        float arcAngle,
        Color innerColor,
        Color outerColor
    ) {
        List<Point2D> innerPoints = getPointsForCircleArc(innerRadius, startAngle, arcAngle);
        List<Point2D> outerPoints = getPointsForCircleArc(outerRadius, startAngle, arcAngle);

        graphics.field_59826.method_70919(new RadialSectorRenderState(
            new Matrix3x2f(graphics.method_51448()),
            (int) (innerRadius * 2),
            (int) (outerRadius * 2),
            innerPoints,
            outerPoints,
            innerColor,
            outerColor
        ));
    }

    private static List<Point2D> getPointsForCircleArc(float radius, float startAngle, float arcAngle) {
        int segmentCount = Math.abs(arcAngle) <= 90 ? 16 : 32;
        List<Point2D> points = new ArrayList<>(segmentCount);


        float theta = (class_3532.field_29847 * arcAngle) / (float) (segmentCount - 1);
        float t = class_3532.field_29847 * startAngle;

        for (int i = 0; i < segmentCount; i++) {
            points.add(new Point2D.Float((float) (radius * Math.cos(t)), (float) (radius * Math.sin(t))));

            t += theta;
        }

        return points;
    }


    //just like AbstractGui#drawTexture, but with a color at every vertex
    public static void drawColoredTexture(
        class_332 graphics,
        class_11231 texture,
        Color c,
        int x,
        int y,
        int tex_left,
        int tex_top,
        int width,
        int height
    ) {
        drawColoredTexture(graphics, texture, c, x, y, (float) tex_left, (float) tex_top, width, height, 256, 256);
    }

    public static void drawColoredTexture(
        class_332 graphics,
        class_11231 texture,
        Color c,
        int x,
        int y,
        float tex_left,
        float tex_top,
        int width,
        int height,
        int sheet_width,
        int sheet_height
    ) {
        drawColoredTexture(graphics, texture, c, x, x + width, y, y + height, width, height, tex_left, tex_top, sheet_width, sheet_height);
    }

    public static void drawStretched(class_332 graphics, int left, int top, int w, int h, TextureSheetSegment tex) {
        drawTexturedQuad(
            graphics,
            tex.bind(),
            Color.WHITE,
            left,
            left + w,
            top,
            top + h,
            tex.getStartX() / 256f,
            (tex.getStartX() + tex.getWidth()) / 256f,
            tex.getStartY() / 256f,
            (tex.getStartY() + tex.getHeight()) / 256f
        );
    }

    public static void drawCropped(class_332 graphics, int left, int top, int w, int h, TextureSheetSegment tex) {
        drawTexturedQuad(
            graphics,
            tex.bind(),
            Color.WHITE,
            left,
            left + w,
            top,
            top + h,
            tex.getStartX() / 256f,
            (tex.getStartX() + w) / 256f,
            tex.getStartY() / 256f,
            (tex.getStartY() + h) / 256f
        );
    }

    private static void drawColoredTexture(
        class_332 graphics,
        class_11231 texture,
        Color c,
        int left,
        int right,
        int top,
        int bot,
        int tex_width,
        int tex_height,
        float tex_left,
        float tex_top,
        int sheet_width,
        int sheet_height
    ) {
        drawTexturedQuad(
            graphics,
            texture,
            c,
            left,
            right,
            top,
            bot,
            (tex_left + 0.0F) / (float) sheet_width,
            (tex_left + (float) tex_width) / (float) sheet_width,
            (tex_top + 0.0F) / (float) sheet_height,
            (tex_top + (float) tex_height) / (float) sheet_height
        );
    }

    private static void drawTexturedQuad(
        class_332 graphics,
        class_11231 texture,
        Color c,
        int left,
        int right,
        int top,
        int bot,
        float u1,
        float u2,
        float v1,
        float v2
    ) {
        graphics.field_59826.method_70919(new TexturedQuadRenderState(
            new Matrix3x2f(graphics.method_51448()),
            texture,
            left,
            right,
            top,
            bot,
            c,
            u1,
            u2,
            v1,
            v2
        ));
    }

    public static void flipForGuiRender(class_4587 poseStack) {
        poseStack.method_34425(new Matrix4f().scaling(1, -1, 1));
    }

    public static class CustomRenderTarget extends class_276 {
        public CustomRenderTarget(@Nullable String name, boolean useDepth) {
            super(name, useDepth);
        }

        public static CustomRenderTarget create(class_1041 mainWindow) {
            CustomRenderTarget framebuffer = new CustomRenderTarget("Custom", true);
            framebuffer.method_1234(mainWindow.method_4480(), mainWindow.method_4507());
            return framebuffer;
        }

        @Override
        public void method_1231(int width, int height) {
            class_10865 device = ((class_10865) RenderSystem.getDevice());
            int i = device.getMaxTextureSize();
            if (width > 0 && width <= i && height > 0 && height <= i) {
                field_1480 = width;
                field_1477 = height;
                field_1482 = width;
                field_1481 = height;
                field_1475 = device.createTexture(() -> field_56738 + " / Color", 15, TextureFormat.RGBA8, width, height, 1, 1);
                field_60567 = device.createTextureView(field_1475);
                field_1475.setAddressMode(AddressMode.CLAMP_TO_EDGE);
                method_1232(FilterMode.NEAREST, true);
                if (field_1478) {
                    field_56739 = createDepthTexture(() -> field_56738 + " / Depth", 15, TextureFormat.DEPTH32, width, height, 1, 1);
                    field_60568 = device.createTextureView(field_56739);
                    field_56739.setTextureFilter(FilterMode.NEAREST, false);
                    field_56739.setAddressMode(AddressMode.CLAMP_TO_EDGE);
                    setupFramebuffer(((class_10868) field_1475), ((class_10868) field_56739).method_68427());
                }
            } else {
                throw new IllegalArgumentException("Window " + width + "x" + height + " size out of bounds (max. size: " + i + ")");
            }
        }

        private static GpuTexture createDepthTexture(
            @Nullable Supplier<String> supplier,
            int usage,
            TextureFormat textureFormat,
            int width,
            int height,
            int depthOrLayers,
            int mipLevels
        ) {
            class_10861 debugLabelManager = ((class_10865) RenderSystem.getDevice()).method_68377();
            String label = debugLabelManager.method_68370() && supplier != null ? supplier.get() : null;
            if (mipLevels < 1) {
                throw new IllegalArgumentException("mipLevels must be at least 1");
            } else {
                GlStateManager.clearGlErrors();
                int glId = GlStateManager._genTexture();
                if (label == null) {
                    label = String.valueOf(glId);
                }

                GlStateManager._bindTexture(glId);
                GlStateManager._texParameter(GlConst.GL_TEXTURE_2D, GL12.GL_TEXTURE_MAX_LEVEL, mipLevels - 1);
                GlStateManager._texParameter(GlConst.GL_TEXTURE_2D, GL12.GL_TEXTURE_MIN_LOD, 0);
                GlStateManager._texParameter(GlConst.GL_TEXTURE_2D, GL12.GL_TEXTURE_MAX_LOD, mipLevels - 1);
                if (textureFormat.hasDepthAspect()) {
                    GlStateManager._texParameter(GlConst.GL_TEXTURE_2D, GlConst.GL_TEXTURE_COMPARE_MODE, 0);
                }

                for (int m = 0; m < mipLevels; m++) {
                    GlStateManager._texImage2D(
                        GlConst.GL_TEXTURE_2D,
                        m,
                        GL30.GL_DEPTH32F_STENCIL8,
                        width >> m,
                        height >> m,
                        0,
                        GL30.GL_DEPTH_STENCIL,
                        GL30.GL_FLOAT_32_UNSIGNED_INT_24_8_REV,
                        null
                    );
                }

                int m = GlStateManager._getError();
                if (m == GlConst.GL_OUT_OF_MEMORY) {
                    throw new class_10783("Could not allocate texture of " + width + "x" + height + " for " + label);
                } else if (m != 0) {
                    throw new IllegalStateException("OpenGL error " + m);
                } else {
                    class_10868 glTexture = new class_10868(usage, label, textureFormat, width, height, depthOrLayers, mipLevels, glId);
                    debugLabelManager.method_68374(glTexture);
                    return glTexture;
                }
            }
        }

        private static void setupFramebuffer(class_10868 colorAttachment, int depthAttachmentId) {
            int framebufferId = GlStateManager.glGenFramebuffers();
            int target = GlConst.GL_DRAW_FRAMEBUFFER;
            int fbo = GlStateManager.getFrameBuffer(target);
            GlStateManager._glBindFramebuffer(target, framebufferId);
            GlStateManager._glFramebufferTexture2D(target, GlConst.GL_COLOR_ATTACHMENT0, GlConst.GL_TEXTURE_2D, colorAttachment.method_68427(), 0);
            GlStateManager._glFramebufferTexture2D(target, GlConst.GL_DEPTH_ATTACHMENT, GlConst.GL_TEXTURE_2D, depthAttachmentId, 0);
            GlStateManager._glFramebufferTexture2D(target, GL30.GL_STENCIL_ATTACHMENT, GlConst.GL_TEXTURE_2D, depthAttachmentId, 0);
            GlStateManager._glBindFramebuffer(target, fbo);
            colorAttachment.field_57885.put(depthAttachmentId, framebufferId);
        }

        public void renderWithAlpha(class_4587 poseStack, float alpha) {
            class_1041 window = class_310.method_1551().method_22683();

            float guiScaledWidth = window.method_4486();
            float guiScaledHeight = window.method_4502();

            float vx = guiScaledWidth;
            float vy = guiScaledHeight;
            float tx = (float) field_1480 / (float) field_1482;
            float ty = (float) field_1477 / (float) field_1481;

            class_310 minecraft = class_310.method_1551();
            Matrix4f matrix4f = poseStack.method_23760().method_23761();
            RenderSystem.backupProjectionMatrix();
            RenderSystem.setProjectionMatrix(PROJECTION.method_71123(matrix4f), class_10366.field_54954);
            GpuBufferSlice dynamicTransformsBuffer = RenderSystem.getDynamicUniforms().method_71106(
                new Matrix4f().setTranslation(0.0F, 0.0F, -2000.0F),
                new Vector4f(1.0F, 1.0F, 1.0F, 1.0F),
                new Vector3f(),
                new Matrix4f(),
                0.0F
            );

            VertexFormat.class_5596 vertexFormatMode = BLIT_SCREEN.getVertexFormatMode();
            VertexFormat vertexFormat = BLIT_SCREEN.getVertexFormat();
            class_289 tesselator = class_289.method_1348();
            class_287 bufferbuilder = tesselator.method_60827(vertexFormatMode, vertexFormat);
            bufferbuilder.method_22912(0, vy, 0).method_22913(0, 0).method_22915(1, 1, 1, alpha);
            bufferbuilder.method_22912(vx, vy, 0).method_22913(tx, 0).method_22915(1, 1, 1, alpha);
            bufferbuilder.method_22912(vx, 0, 0).method_22913(tx, ty).method_22915(1, 1, 1, alpha);
            bufferbuilder.method_22912(0, 0, 0).method_22913(0, ty).method_22915(1, 1, 1, alpha);
            class_9801 buffer = bufferbuilder.method_60800();

            class_276 framebuffer = minecraft.method_1522();
            RenderSystem.class_5590 shapeIndexBuffer = RenderSystem.getSequentialBuffer(vertexFormatMode);
            GpuBuffer gpuBuffer = vertexFormat.uploadImmediateVertexBuffer(buffer.method_60818());
            int count = buffer.method_60822().comp_751();
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(
                () -> "Immediate draw for UIRenderHelper",
                framebuffer.method_71639(),
                OptionalInt.empty(),
                framebuffer.method_71640(),
                OptionalDouble.empty()
            )) {
                renderPass.setPipeline(BLIT_SCREEN);
                RenderSystem.bindDefaultUniforms(renderPass);
                renderPass.setVertexBuffer(0, shapeIndexBuffer.method_68274(count));
                renderPass.setIndexBuffer(gpuBuffer, shapeIndexBuffer.method_31924());
                renderPass.bindSampler("InSampler", field_60567);
                renderPass.setUniform("DynamicTransforms", dynamicTransformsBuffer);
                renderPass.drawIndexed(0, 0, count, 1);
            }

            buffer.close();
            RenderSystem.restoreProjectionMatrix();
        }

    }

}
