package com.zurrtum.create.client.compat.rei.category;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.compat.rei.CreateCategory;
import com.zurrtum.create.client.compat.rei.renderer.TwoIconRenderer;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.FanRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.compat.rei.display.FanBlastingDisplay;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3612;
import org.joml.Matrix3x2f;

import java.util.List;

public class FanBlastingCategory extends CreateCategory<FanBlastingDisplay> {
    @Override
    public CategoryIdentifier<? extends FanBlastingDisplay> getCategoryIdentifier() {
        return ReiCommonPlugin.FAN_BLASTING;
    }

    @Override
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.fan_blasting");
    }

    @Override
    public Renderer getIcon() {
        return new TwoIconRenderer(AllItems.PROPELLER, class_1802.field_8187);
    }

    @Override
    public void addWidgets(List<Widget> widgets, FanBlastingDisplay display, Rectangle bounds) {
        Point input = new Point(bounds.x + 26, bounds.y + 53);
        Point output = new Point(bounds.x + 146, bounds.y + 53);
        widgets.add(Widgets.createDrawableWidget((class_332 graphics, int mouseX, int mouseY, float delta) -> {
            drawSlotBackground(graphics, input, output);
            AllGuiTextures.JEI_SHADOW.render(graphics, bounds.x + 51, bounds.y + 32);
            AllGuiTextures.JEI_LIGHT.render(graphics, bounds.x + 70, bounds.y + 44);
            AllGuiTextures.JEI_LONG_ARROW.render(graphics, bounds.x + 59, bounds.y + 56);
            graphics.field_59826.method_70922(new FanRenderState(
                new Matrix3x2f(graphics.method_51448()),
                bounds.x + 61,
                bounds.y + 10,
                class_3612.field_15908.method_15785().method_15759()
            ));
        }));
        widgets.add(createInputSlot(input).entries(display.input()));
        widgets.add(createOutputSlot(output).entries(display.output()));
    }

    @Override
    public int getDisplayHeight() {
        return 82;
    }
}
