package com.zurrtum.create.client.compat.rei.widget;

import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import java.util.List;
import java.util.function.Function;

public class TooltipWidget extends Widget {
    private final Rectangle bounds;
    private final Function<class_310, Tooltip> tooltip;

    public TooltipWidget(int x, int y, int width, int height, class_2561... text) {
        this(x, y, width, height, mc -> Tooltip.create(text));
    }

    public TooltipWidget(int x, int y, int width, int height, List<class_2561> text) {
        this(x, y, width, height, mc -> Tooltip.create(text));
    }

    public TooltipWidget(int x, int y, int width, int height, Function<class_310, Tooltip> tooltip) {
        this.bounds = new Rectangle(x, y, width, height);
        this.tooltip = tooltip;
    }

    @Override
    public List<? extends class_364> method_25396() {
        return List.of();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        if (bounds.contains(mouseX, mouseY)) {
            Tooltip tooltip = this.tooltip.apply(minecraft);
            if (tooltip != null) {
                tooltip.queue();
            }
        }
    }
}
