package com.zurrtum.create.client.content.contraptions.actors.harvester;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterBlock;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterBlockEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;

public class HarvesterRenderer extends SafeBlockEntityRenderer<HarvesterBlockEntity> {

    private static final class_243 PIVOT = new class_243(0, 6, 9);

    public HarvesterRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(HarvesterBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        class_2680 blockState = be.method_11010();
        SuperByteBuffer superBuffer = CachedBuffers.partial(AllPartialModels.HARVESTER_BLADE, blockState);
        transform(be.method_10997(), blockState.method_11654(HarvesterBlock.field_11177), superBuffer, be.getAnimatedSpeed(), PIVOT);
        superBuffer.light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
    }

    public static void renderInContraption(
        MovementContext context,
        VirtualRenderWorld renderWorld,
        ContraptionMatrices matrices,
        class_4597 buffers
    ) {
        class_2680 blockState = context.state;
        class_2350 facing = blockState.method_11654(class_2741.field_12481);
        SuperByteBuffer superBuffer = CachedBuffers.partial(AllPartialModels.HARVESTER_BLADE, blockState);
        float speed = !VecHelper.isVecPointingTowards(context.relativeMotion, facing.method_10153()) ? context.getAnimationSpeed() : 0;
        if (context.contraption.stalled)
            speed = 0;

        superBuffer.transform(matrices.getModel());
        transform(context.world, facing, superBuffer, speed, PIVOT);

        superBuffer.light(class_761.method_23794(renderWorld, context.localPos)).useLevelLight(context.world, matrices.getWorld())
            .renderInto(matrices.getViewProjection(), buffers.getBuffer(class_1921.method_23579()));
    }

    public static void transform(class_1937 world, class_2350 facing, SuperByteBuffer superBuffer, float speed, class_243 pivot) {
        float originOffset = 1 / 16f;
        class_243 rotOffset = new class_243(0, pivot.field_1351 * originOffset, pivot.field_1350 * originOffset);
        float time = AnimationTickHolder.getRenderTime(world) / 20;
        float angle = (time * speed) % 360;

        superBuffer.rotateCentered(AngleHelper.rad(AngleHelper.horizontalAngle(facing)), class_2350.field_11036)
            .translate(rotOffset.field_1352, rotOffset.field_1351, rotOffset.field_1350).rotate(AngleHelper.rad(angle), class_2350.field_11039)
            .translate(-rotOffset.field_1352, -rotOffset.field_1351, -rotOffset.field_1350);
    }
}
