package com.zurrtum.create.client.content.contraptions.actors.trainControls;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_761;

public class ControlsRenderer {
    public static void render(
        MovementContext context,
        VirtualRenderWorld renderWorld,
        ContraptionMatrices matrices,
        class_4597 buffer,
        float equipAnimation,
        float firstLever,
        float secondLever
    ) {
        class_2680 state = context.state;
        class_2350 facing = state.method_11654(ControlsBlock.field_11177);

        SuperByteBuffer cover = CachedBuffers.partial(AllPartialModels.TRAIN_CONTROLS_COVER, state);
        float hAngle = 180 + AngleHelper.horizontalAngle(facing);
        class_4587 ms = matrices.getModel();
        cover.transform(ms).center().rotateYDegrees(hAngle).uncenter().light(class_761.method_23794(renderWorld, context.localPos))
            .useLevelLight(context.world, matrices.getWorld())
            .renderInto(matrices.getViewProjection(), buffer.getBuffer(class_1921.method_23579()));

        double yOffset = class_3532.method_16439(equipAnimation * equipAnimation, -0.15f, 0.05f);

        for (boolean first : Iterate.trueAndFalse) {
            float vAngle = class_3532.method_15363(first ? firstLever * 70 - 25 : secondLever * 15, -45, 45);
            SuperByteBuffer lever = CachedBuffers.partial(AllPartialModels.TRAIN_CONTROLS_LEVER, state);
            ms.method_22903();
            TransformStack.of(ms).center().rotateYDegrees(hAngle).translate(0, 4 / 16f, 4 / 16f).rotateXDegrees(vAngle - 45).translate(0, yOffset, 0)
                .rotateXDegrees(45).uncenter().translate(0, -6 / 16f, -3 / 16f).translate(first ? 0 : 6 / 16f, 0, 0);
            lever.transform(ms).light(class_761.method_23794(renderWorld, context.localPos))
                .useLevelLight(context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), buffer.getBuffer(class_1921.method_23577()));
            ms.method_22909();
        }
    }
}
