package com.zurrtum.create.client.content.contraptions.bearing;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.contraptions.bearing.BearingBlock;
import com.zurrtum.create.content.contraptions.bearing.IBearingBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class BearingRenderer<T extends KineticBlockEntity & IBearingBlockEntity> extends KineticBlockEntityRenderer<T> {

    public BearingRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(T be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {

        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);

        final class_2350 facing = be.method_11010().method_11654(class_2741.field_12525);
        PartialModel top = be.isWoodenTop() ? AllPartialModels.BEARING_TOP_WOODEN : AllPartialModels.BEARING_TOP;
        SuperByteBuffer superBuffer = CachedBuffers.partial(top, be.method_11010());

        float interpolatedAngle = be.getInterpolatedAngle(partialTicks - 1);
        kineticRotationTransform(superBuffer, be, facing.method_10166(), (float) (interpolatedAngle / 180 * Math.PI), light);

        if (facing.method_10166().method_10179())
            superBuffer.rotateCentered(AngleHelper.rad(AngleHelper.horizontalAngle(facing.method_10153())), class_2350.field_11036);
        superBuffer.rotateCentered(AngleHelper.rad(-90 - AngleHelper.verticalAngle(facing)), class_2350.field_11034);
        superBuffer.renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be, class_2680 state) {
        return CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state, state.method_11654(BearingBlock.FACING).method_10153());
    }

}
