package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.render.BlockEntityRenderHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.class_10017;
import net.minecraft.class_11515;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import net.minecraft.client.render.*;
import org.apache.commons.lang3.tuple.Pair;

public class ContraptionEntityRenderer<C extends AbstractContraptionEntity, S extends ContraptionEntityRenderer.AbstractContraptionState> extends class_897<C, S> {
    public ContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public boolean shouldRender(C entity, class_4604 frustum, double cameraX, double cameraY, double cameraZ) {
        if (entity.getContraption() == null)
            return false;
        if (!entity.isAliveOrStale())
            return false;
        if (!entity.isReadyForRender())
            return false;

        return super.method_3933(entity, frustum, cameraX, cameraY, cameraZ);
    }

    @Override
    @SuppressWarnings("unchecked")
    public S method_55269() {
        return (S) new AbstractContraptionState();
    }

    @Override
    public void render(S state, class_4587 poseStack, class_4597 buffers, int overlay) {
        if (state.contraption == null) {
            return;
        }

        ContraptionRenderInfo renderInfo = ContraptionRenderInfo.get(state.contraption);
        VirtualRenderWorld renderWorld = renderInfo.getRenderWorld();
        ContraptionMatrices matrices = renderInfo.getMatrices();
        matrices.setup((matrixStack, partialTicks) -> transform(state, matrixStack, partialTicks), poseStack, state);

        if (!VisualizationManager.supportsVisualization(state.world)) {
            for (class_11515 renderType : class_11515.values()) {
                SuperByteBuffer sbb = ContraptionRenderInfo.getBuffer(state.contraption, renderWorld, renderType);
                if (!sbb.isEmpty()) {
                    class_4588 vc = buffers.getBuffer(getRenderLayer(renderType));
                    sbb.transform(matrices.getModel()).useLevelLight(state.world, matrices.getWorld()).renderInto(poseStack, vc);
                }
            }
        }

        BlockEntityRenderHelper.renderBlockEntities(
            state.world,
            renderWorld,
            state.contraption.getRenderedBEs(),
            matrices.getModelViewProjection(),
            matrices.getLight(),
            buffers
        );
        renderActors(state.world, renderWorld, state.contraption, matrices, buffers);

        matrices.clear();
    }

    private class_1921 getRenderLayer(class_11515 layer) {
        return switch (layer) {
            case field_60923 -> class_1921.method_23577();
            case field_60924 -> class_1921.method_23579();
            case field_60925 -> class_1921.method_23581();
            case field_60926 -> PonderRenderTypes.translucent();
            case field_60927 -> class_1921.method_29997();
        };
    }

    public void transform(S state, class_4587 matrixStack, float partialTicks) {
    }

    @Override
    public void updateRenderState(C entity, S state, float tickProgress) {
        state.world = entity.method_37908();
        state.contraption = entity.getContraption();
        state.lastRenderX = entity.field_6038;
        state.lastRenderY = entity.field_5971;
        state.lastRenderZ = entity.field_5989;
        state.entityX = entity.method_23317();
        state.entityY = entity.method_23318();
        state.entityZ = entity.method_23321();
    }

    private static void renderActors(
        class_1937 level,
        VirtualRenderWorld renderWorld,
        Contraption c,
        ContraptionMatrices matrices,
        class_4597 buffer
    ) {
        class_4587 m = matrices.getModel();

        for (Pair<class_3499.class_3501, MovementContext> actor : c.getActors()) {
            MovementContext context = actor.getRight();
            if (context == null)
                continue;
            if (context.world == null)
                context.world = level;
            class_3499.class_3501 blockInfo = actor.getLeft();

            MovementBehaviour movementBehaviour = MovementBehaviour.REGISTRY.get(blockInfo.comp_1342());
            if (movementBehaviour != null) {
                MovementRenderBehaviour render = movementBehaviour.getAttachRender();
                if (render == null || c.isHiddenInPortal(blockInfo.comp_1341()))
                    continue;
                m.method_22903();
                TransformStack.of(m).translate(blockInfo.comp_1341());
                render.renderInContraption(context, renderWorld, matrices, buffer);
                m.method_22909();
            }
        }
    }

    public static class AbstractContraptionState extends class_10017 {
        public class_1937 world;
        public Contraption contraption;
        public double lastRenderX;
        public double lastRenderY;
        public double lastRenderZ;
        public double entityX;
        public double entityY;
        public double entityZ;
    }
}
