package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.contraptions.render.ContraptionEntityRenderer.AbstractContraptionState;
import org.joml.Matrix4f;

import java.util.function.BiConsumer;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

/**
 * <p>
 * ContraptionMatrices must be cleared and setup per-contraption per-frame
 * </p>
 */
public class ContraptionMatrices {

    private final class_4587 modelViewProjection = new class_4587();
    private final class_4587 viewProjection = new class_4587();
    private final class_4587 model = new class_4587();
    private final Matrix4f world = new Matrix4f();
    private final Matrix4f light = new Matrix4f();

    void setup(BiConsumer<class_4587, Float> transform, class_4587 viewProjection, AbstractContraptionState state) {
        float partialTicks = AnimationTickHolder.getPartialTicks();

        this.viewProjection.method_22903();
        transform(this.viewProjection, viewProjection);
        model.method_22903();
        transform.accept(model, partialTicks);

        modelViewProjection.method_22903();
        transform(modelViewProjection, viewProjection);
        transform(modelViewProjection, model);

        translateToEntity(world, state, partialTicks);

        light.set(world);
        light.mul(model.method_23760().method_23761());
    }

    void clear() {
        clearStack(modelViewProjection);
        clearStack(viewProjection);
        clearStack(model);
        world.identity();
        light.identity();
    }

    public class_4587 getModelViewProjection() {
        return modelViewProjection;
    }

    public class_4587 getViewProjection() {
        return viewProjection;
    }

    public class_4587 getModel() {
        return model;
    }

    public Matrix4f getWorld() {
        return world;
    }

    public Matrix4f getLight() {
        return light;
    }

    public static void transform(class_4587 ms, class_4587 transform) {
        ms.method_23760().method_23761().mul(transform.method_23760().method_23761());
        ms.method_23760().method_23762().mul(transform.method_23760().method_23762());
    }

    public static void translateToEntity(Matrix4f matrix, AbstractContraptionState state, float partialTicks) {
        double x = class_3532.method_16436(partialTicks, state.lastRenderX, state.entityX);
        double y = class_3532.method_16436(partialTicks, state.lastRenderY, state.entityY);
        double z = class_3532.method_16436(partialTicks, state.lastRenderZ, state.entityZ);
        matrix.setTranslation((float) x, (float) y, (float) z);
    }

    public static void clearStack(class_4587 ms) {
        while (!ms.method_67795()) {
            ms.method_22909();
        }
    }

}
