package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.client.catnip.render.ShadedBlockSbbBuilder;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.Contraption.RenderedBlocks;
import com.zurrtum.create.content.contraptions.ContraptionWorld;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;

public class ContraptionRenderInfo {
    public static final SuperByteBufferCache.Compartment<Pair<Contraption, class_11515>> CONTRAPTION = new SuperByteBufferCache.Compartment<>();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    private final VirtualRenderWorld renderWorld;
    private final ContraptionMatrices matrices = new ContraptionMatrices();

    ContraptionRenderInfo(class_1937 level, Contraption contraption) {
        this.renderWorld = setupRenderWorld(level, contraption);
    }

    @SuppressWarnings("unchecked")
    public static ContraptionRenderInfo get(Contraption contraption) {
        AtomicReference<ContraptionRenderInfo> renderInfo = (AtomicReference<ContraptionRenderInfo>) contraption.renderInfo;
        var out = renderInfo.getAcquire();
        if (out == null) {
            // Another thread may hit this block in the same moment.
            // One thread will win and the ContraptionRenderInfo that
            // it generated will become canonical. It's important that
            // we only maintain one RenderInfo instance, specifically
            // for the VirtualRenderWorld inside.
            renderInfo.compareAndExchangeRelease(null, new ContraptionRenderInfo(contraption.entity.method_37908(), contraption));

            // Must get again to ensure we have the canonical instance.
            out = renderInfo.getAcquire();
        }
        return out;
    }

    public VirtualRenderWorld getRenderWorld() {
        return renderWorld;
    }

    public ContraptionMatrices getMatrices() {
        return matrices;
    }

    public static SuperByteBuffer getBuffer(Contraption contraption, VirtualRenderWorld renderWorld, class_11515 renderType) {
        return SuperByteBufferCache.getInstance()
            .get(CONTRAPTION, Pair.of(contraption, renderType), () -> buildStructureBuffer(contraption, renderWorld, renderType));
    }

    public static void invalidate(Contraption contraption) {
        for (class_11515 renderType : class_11515.values()) {
            SuperByteBufferCache.getInstance().invalidate(CONTRAPTION, Pair.of(contraption, renderType));
        }
    }

    public static VirtualRenderWorld setupRenderWorld(class_1937 level, Contraption c) {
        ContraptionWorld contraptionWorld = c.getContraptionWorld();

        class_2338 origin = c.anchor;
        int minBuildHeight = contraptionWorld.method_31607();
        int height = contraptionWorld.method_31605();
        VirtualRenderWorld renderWorld = new VirtualRenderWorld(level, minBuildHeight, height, origin) {
            @Override
            public boolean supportsVisualization() {
                return VisualizationManager.supportsVisualization(level);
            }
        };

        renderWorld.setBlockEntities(c.presentBlockEntities.values());
        for (class_3499.class_3501 info : c.getBlocks().values())
            renderWorld.method_8652(info.comp_1341(), info.comp_1342(), 0);

        renderWorld.runLightEngine();
        return renderWorld;
    }

    @SuppressWarnings("removal")
    private static SuperByteBuffer buildStructureBuffer(Contraption contraption, VirtualRenderWorld renderWorld, class_11515 layer) {
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_778 renderer = dispatcher.method_3350();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();

        class_4587 poseStack = objects.poseStack;
        class_5819 random = objects.random;
        RenderedBlocks blocks = contraption.getRenderedBlocks();

        ShadedBlockSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.begin();

        class_778.method_20544();
        for (class_2338 pos : blocks.positions()) {
            class_2680 state = blocks.lookup().apply(pos);
            if (state.method_26217() == class_2464.field_11458) {
                class_1087 model = dispatcher.method_3349(state);
                long randomSeed = state.method_26190(pos);
                random.method_43052(randomSeed);
                if (class_4696.method_23679(state) == layer) {
                    poseStack.method_22903();
                    poseStack.method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());
                    List<class_10889> parts = new ObjectArrayList<>();
                    if (WrapperBlockStateModel.unwrapCompat(model) instanceof WrapperBlockStateModel wrapper) {
                        wrapper.addPartsWithInfo(renderWorld, pos, state, random, parts);
                    } else {
                        model.method_68513(random, parts);
                    }
                    renderer.method_3374(renderWorld, parts, state, pos, poseStack, sbbBuilder, true, class_4608.field_21444);
                    poseStack.method_22909();
                }
            }
        }
        class_778.method_20545();

        return sbbBuilder.end();
    }

    @SuppressWarnings("removal")
    private static class ThreadLocalObjects {
        public final class_4587 poseStack = new class_4587();
        public final class_5819 random = class_5819.method_43053();
        public final ShadedBlockSbbBuilder sbbBuilder = ShadedBlockSbbBuilder.create();
    }
}
