package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.infrastructure.packet.c2s.ChainPackageInteractionPacket;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.minecraft.class_746;

public class ChainPackageInteractionHandler {
    public static boolean onUse(class_310 mc) {
        class_746 player = mc.field_1724;
        class_1799 stack = player.method_6047();
        if (stack.method_31573(AllItemTags.TOOLS_WRENCH) || stack.method_31574(class_1802.field_23983) || stack.method_31574(AllItems.PACKAGE_FROGPORT)) {
            return false;
        }
        double range = player.method_45325(class_5134.field_47758) + 1;
        for (Map.Entry<Integer, ChainConveyorPackagePhysicsData> entry : ChainConveyorClientBehaviour.physicsDataCache.get(mc.field_1687).asMap()
            .entrySet()) {
            ChainConveyorPackagePhysicsData data = entry.getValue();
            if (data == null || data.targetPos == null || data.beReference == null)
                continue;
            class_238 bounds = new class_238(data.targetPos, data.targetPos).method_989(0, -.25, 0).method_1012(0, 0.5, 0).method_1014(0.45);

            class_243 from = RaycastHelper.getTraceOrigin(player);
            class_243 to = RaycastHelper.getTraceTarget(player, range, from);

            if (bounds.method_992(from, to).isEmpty())
                continue;

            ChainConveyorBlockEntity ccbe = data.beReference.get();
            if (ccbe == null || ccbe.method_11015())
                continue;

            int i = entry.getKey();
            for (ChainConveyorPackage pckg : ccbe.getLoopingPackages()) {
                if (pckg.netId == i) {
                    player.field_3944.method_52787(new ChainPackageInteractionPacket(ccbe.method_11016(), class_2338.field_10980, pckg.chainPosition, true));
                    return true;
                }
            }

            for (class_2338 connection : ccbe.connections) {
                List<ChainConveyorPackage> list = ccbe.getTravellingPackages().get(connection);
                if (list == null)
                    continue;
                for (ChainConveyorPackage pckg : list) {
                    if (pckg.netId == i) {
                        player.field_3944.method_52787(new ChainPackageInteractionPacket(ccbe.method_11016(), connection, pckg.chainPosition, true));
                        return true;
                    }
                }
            }
        }
        return false;
    }
}
